/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsWarningCollection;
import com.oracle.bmc.loganalytics.requests.ListWarningsRequest;
import com.oracle.bmc.loganalytics.responses.ListWarningsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWarningsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListWarningsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListWarningsRequest interceptRequest(ListWarningsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListWarningsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("warnings");
        if (request.getWarningState() != null) {
            target = target.queryParam("warningState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getWarningState().getValue())});
        }
        if (request.getSourceName() != null) {
            target = target.queryParam("sourceName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceName())});
        }
        if (request.getSourcePattern() != null) {
            target = target.queryParam("sourcePattern", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourcePattern())});
        }
        if (request.getWarningMessage() != null) {
            target = target.queryParam("warningMessage", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getWarningMessage())});
        }
        if (request.getEntityName() != null) {
            target = target.queryParam("entityName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEntityName())});
        }
        if (request.getEntityType() != null) {
            target = target.queryParam("entityType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEntityType())});
        }
        if (request.getWarningType() != null) {
            target = target.queryParam("warningType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getWarningType())});
        }
        if (request.getIsNoSource() != null) {
            target = target.queryParam("isNoSource", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsNoSource())});
        }
        if (request.getStartTime() != null) {
            target = target.queryParam("startTime", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStartTime())});
        }
        if (request.getEndTime() != null) {
            target = target.queryParam("endTime", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEndTime())});
        }
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListWarningsResponse> fromResponse() {
        Function<Response, ListWarningsResponse> transformer = new Function<Response, ListWarningsResponse>(){

            public ListWarningsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ListWarningsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsWarningCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListWarningsResponse.Builder builder = ListWarningsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsWarningCollection((LogAnalyticsWarningCollection)response.getItem());
                Optional opcPrevPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-prev-page");
                if (opcPrevPageHeader.isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListWarningsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

