/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.SourceMappingResponse;
import com.oracle.bmc.loganalytics.requests.ValidateSourceMappingRequest;
import com.oracle.bmc.loganalytics.responses.ValidateSourceMappingResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateSourceMappingConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateSourceMappingConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ValidateSourceMappingRequest interceptRequest(ValidateSourceMappingRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ValidateSourceMappingRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getObjectLocation(), (String)"objectLocation is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getFilename(), (String)"filename is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getLogSourceName(), (String)"logSourceName is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("uploads").path("actions").path("validateSourceMapping");
        target = target.queryParam("objectLocation", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getObjectLocation())});
        target = target.queryParam("filename", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilename())});
        target = target.queryParam("logSourceName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLogSourceName())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ValidateSourceMappingResponse> fromResponse() {
        Function<Response, ValidateSourceMappingResponse> transformer = new Function<Response, ValidateSourceMappingResponse>(){

            public ValidateSourceMappingResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ValidateSourceMappingResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SourceMappingResponse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ValidateSourceMappingResponse.Builder builder = ValidateSourceMappingResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.sourceMappingResponse((SourceMappingResponse)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ValidateSourceMappingResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

