/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAssociationSummaryRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "compartmentId", "opcRequestId"})
    GetAssociationSummaryRequest(String namespaceName, String compartmentId, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAssociationSummaryRequest, Void> {
        private String namespaceName;
        private String compartmentId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAssociationSummaryRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAssociationSummaryRequest build() {
            GetAssociationSummaryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAssociationSummaryRequest buildWithoutInvocationCallback() {
            return new GetAssociationSummaryRequest(this.namespaceName, this.compartmentId, this.opcRequestId);
        }

        public String toString() {
            return "GetAssociationSummaryRequest.Builder(namespaceName=" + this.namespaceName + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

