/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetFieldRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String fieldName;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "fieldName", "opcRequestId"})
    GetFieldRequest(String namespaceName, String fieldName, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.fieldName = fieldName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFieldRequest, Void> {
        private String namespaceName;
        private String fieldName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFieldRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.fieldName(o.getFieldName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFieldRequest build() {
            GetFieldRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetFieldRequest buildWithoutInvocationCallback() {
            return new GetFieldRequest(this.namespaceName, this.fieldName, this.opcRequestId);
        }

        public String toString() {
            return "GetFieldRequest.Builder(namespaceName=" + this.namespaceName + ", fieldName=" + this.fieldName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

