/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetLookupRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String lookupName;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "lookupName", "opcRequestId"})
    GetLookupRequest(String namespaceName, String lookupName, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.lookupName = lookupName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLookupRequest, Void> {
        private String namespaceName;
        private String lookupName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLookupRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.lookupName(o.getLookupName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLookupRequest build() {
            GetLookupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder lookupName(String lookupName) {
            this.lookupName = lookupName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetLookupRequest buildWithoutInvocationCallback() {
            return new GetLookupRequest(this.namespaceName, this.lookupName, this.opcRequestId);
        }

        public String toString() {
            return "GetLookupRequest.Builder(namespaceName=" + this.namespaceName + ", lookupName=" + this.lookupName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

