/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import javax.ws.rs.client.Invocation;

public class ImportCustomContentRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private InputStream importCustomContentFileBody;
    private Boolean isOverwrite;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public InputStream getBody$() {
        return this.importCustomContentFileBody;
    }

    @ConstructorProperties(value={"namespaceName", "importCustomContentFileBody", "isOverwrite", "opcRetryToken", "opcRequestId"})
    ImportCustomContentRequest(String namespaceName, InputStream importCustomContentFileBody, Boolean isOverwrite, String opcRetryToken, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.importCustomContentFileBody = importCustomContentFileBody;
        this.isOverwrite = isOverwrite;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public InputStream getImportCustomContentFileBody() {
        return this.importCustomContentFileBody;
    }

    public Boolean getIsOverwrite() {
        return this.isOverwrite;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportCustomContentRequest, InputStream> {
        private String namespaceName;
        private InputStream importCustomContentFileBody;
        private Boolean isOverwrite;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportCustomContentRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.importCustomContentFileBody(o.getImportCustomContentFileBody());
            this.isOverwrite(o.getIsOverwrite());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportCustomContentRequest build() {
            ImportCustomContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.importCustomContentFileBody(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder importCustomContentFileBody(InputStream importCustomContentFileBody) {
            this.importCustomContentFileBody = importCustomContentFileBody;
            return this;
        }

        public Builder isOverwrite(Boolean isOverwrite) {
            this.isOverwrite = isOverwrite;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ImportCustomContentRequest buildWithoutInvocationCallback() {
            return new ImportCustomContentRequest(this.namespaceName, this.importCustomContentFileBody, this.isOverwrite, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "ImportCustomContentRequest.Builder(namespaceName=" + this.namespaceName + ", importCustomContentFileBody=" + this.importCustomContentFileBody + ", isOverwrite=" + this.isOverwrite + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

