/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListEntityAssociationsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String logAnalyticsEntityId;
    private DirectOrAllAssociations directOrAllAssociations;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "logAnalyticsEntityId", "directOrAllAssociations", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListEntityAssociationsRequest(String namespaceName, String logAnalyticsEntityId, DirectOrAllAssociations directOrAllAssociations, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.logAnalyticsEntityId = logAnalyticsEntityId;
        this.directOrAllAssociations = directOrAllAssociations;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLogAnalyticsEntityId() {
        return this.logAnalyticsEntityId;
    }

    public DirectOrAllAssociations getDirectOrAllAssociations() {
        return this.directOrAllAssociations;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListEntityAssociationsRequest, Void> {
        private String namespaceName;
        private String logAnalyticsEntityId;
        private DirectOrAllAssociations directOrAllAssociations;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListEntityAssociationsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.logAnalyticsEntityId(o.getLogAnalyticsEntityId());
            this.directOrAllAssociations(o.getDirectOrAllAssociations());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListEntityAssociationsRequest build() {
            ListEntityAssociationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder logAnalyticsEntityId(String logAnalyticsEntityId) {
            this.logAnalyticsEntityId = logAnalyticsEntityId;
            return this;
        }

        public Builder directOrAllAssociations(DirectOrAllAssociations directOrAllAssociations) {
            this.directOrAllAssociations = directOrAllAssociations;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListEntityAssociationsRequest buildWithoutInvocationCallback() {
            return new ListEntityAssociationsRequest(this.namespaceName, this.logAnalyticsEntityId, this.directOrAllAssociations, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListEntityAssociationsRequest.Builder(namespaceName=" + this.namespaceName + ", logAnalyticsEntityId=" + this.logAnalyticsEntityId + ", directOrAllAssociations=" + (Object)((Object)this.directOrAllAssociations) + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DirectOrAllAssociations {
        Direct("DIRECT"),
        All("ALL");

        private final String value;
        private static Map<String, DirectOrAllAssociations> map;

        private DirectOrAllAssociations(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DirectOrAllAssociations create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DirectOrAllAssociations: " + key);
        }

        static {
            map = new HashMap<String, DirectOrAllAssociations>();
            for (DirectOrAllAssociations v : DirectOrAllAssociations.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

