/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLabelSourceDetailsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String labelName;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private LabelSourceSortBy labelSourceSortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "labelName", "limit", "page", "sortOrder", "labelSourceSortBy", "opcRequestId"})
    ListLabelSourceDetailsRequest(String namespaceName, String labelName, Integer limit, String page, SortOrder sortOrder, LabelSourceSortBy labelSourceSortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.labelName = labelName;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.labelSourceSortBy = labelSourceSortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LabelSourceSortBy getLabelSourceSortBy() {
        return this.labelSourceSortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLabelSourceDetailsRequest, Void> {
        private String namespaceName;
        private String labelName;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private LabelSourceSortBy labelSourceSortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLabelSourceDetailsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.labelName(o.getLabelName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.labelSourceSortBy(o.getLabelSourceSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLabelSourceDetailsRequest build() {
            ListLabelSourceDetailsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder labelName(String labelName) {
            this.labelName = labelName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder labelSourceSortBy(LabelSourceSortBy labelSourceSortBy) {
            this.labelSourceSortBy = labelSourceSortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLabelSourceDetailsRequest buildWithoutInvocationCallback() {
            return new ListLabelSourceDetailsRequest(this.namespaceName, this.labelName, this.limit, this.page, this.sortOrder, this.labelSourceSortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListLabelSourceDetailsRequest.Builder(namespaceName=" + this.namespaceName + ", labelName=" + this.labelName + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", labelSourceSortBy=" + (Object)((Object)this.labelSourceSortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum LabelSourceSortBy {
        SourceDisplayName("sourceDisplayName"),
        LabelFieldDisplayName("labelFieldDisplayName");

        private final String value;
        private static Map<String, LabelSourceSortBy> map;

        private LabelSourceSortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LabelSourceSortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LabelSourceSortBy: " + key);
        }

        static {
            map = new HashMap<String, LabelSourceSortBy>();
            for (LabelSourceSortBy v : LabelSourceSortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

