/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.loganalytics.model.EntityLifecycleStates;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLogAnalyticsEntitiesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private String name;
    private String nameContains;
    private List<String> entityTypeName;
    private String cloudResourceId;
    private EntityLifecycleStates lifecycleState;
    private String lifecycleDetailsContains;
    private IsManagementAgentIdNull isManagementAgentIdNull;
    private String hostname;
    private String hostnameContains;
    private String sourceId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "compartmentId", "name", "nameContains", "entityTypeName", "cloudResourceId", "lifecycleState", "lifecycleDetailsContains", "isManagementAgentIdNull", "hostname", "hostnameContains", "sourceId", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListLogAnalyticsEntitiesRequest(String namespaceName, String compartmentId, String name, String nameContains, List<String> entityTypeName, String cloudResourceId, EntityLifecycleStates lifecycleState, String lifecycleDetailsContains, IsManagementAgentIdNull isManagementAgentIdNull, String hostname, String hostnameContains, String sourceId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.compartmentId = compartmentId;
        this.name = name;
        this.nameContains = nameContains;
        this.entityTypeName = entityTypeName;
        this.cloudResourceId = cloudResourceId;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetailsContains = lifecycleDetailsContains;
        this.isManagementAgentIdNull = isManagementAgentIdNull;
        this.hostname = hostname;
        this.hostnameContains = hostnameContains;
        this.sourceId = sourceId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public List<String> getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getCloudResourceId() {
        return this.cloudResourceId;
    }

    public EntityLifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetailsContains() {
        return this.lifecycleDetailsContains;
    }

    public IsManagementAgentIdNull getIsManagementAgentIdNull() {
        return this.isManagementAgentIdNull;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHostnameContains() {
        return this.hostnameContains;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLogAnalyticsEntitiesRequest, Void> {
        private String namespaceName;
        private String compartmentId;
        private String name;
        private String nameContains;
        private List<String> entityTypeName;
        private String cloudResourceId;
        private EntityLifecycleStates lifecycleState;
        private String lifecycleDetailsContains;
        private IsManagementAgentIdNull isManagementAgentIdNull;
        private String hostname;
        private String hostnameContains;
        private String sourceId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLogAnalyticsEntitiesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.name(o.getName());
            this.nameContains(o.getNameContains());
            this.entityTypeName(o.getEntityTypeName());
            this.cloudResourceId(o.getCloudResourceId());
            this.lifecycleState(o.getLifecycleState());
            this.lifecycleDetailsContains(o.getLifecycleDetailsContains());
            this.isManagementAgentIdNull(o.getIsManagementAgentIdNull());
            this.hostname(o.getHostname());
            this.hostnameContains(o.getHostnameContains());
            this.sourceId(o.getSourceId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLogAnalyticsEntitiesRequest build() {
            ListLogAnalyticsEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public Builder entityTypeName(List<String> entityTypeName) {
            this.entityTypeName = entityTypeName;
            return this;
        }

        public Builder cloudResourceId(String cloudResourceId) {
            this.cloudResourceId = cloudResourceId;
            return this;
        }

        public Builder lifecycleState(EntityLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleDetailsContains(String lifecycleDetailsContains) {
            this.lifecycleDetailsContains = lifecycleDetailsContains;
            return this;
        }

        public Builder isManagementAgentIdNull(IsManagementAgentIdNull isManagementAgentIdNull) {
            this.isManagementAgentIdNull = isManagementAgentIdNull;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder hostnameContains(String hostnameContains) {
            this.hostnameContains = hostnameContains;
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLogAnalyticsEntitiesRequest buildWithoutInvocationCallback() {
            return new ListLogAnalyticsEntitiesRequest(this.namespaceName, this.compartmentId, this.name, this.nameContains, this.entityTypeName, this.cloudResourceId, this.lifecycleState, this.lifecycleDetailsContains, this.isManagementAgentIdNull, this.hostname, this.hostnameContains, this.sourceId, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListLogAnalyticsEntitiesRequest.Builder(namespaceName=" + this.namespaceName + ", compartmentId=" + this.compartmentId + ", name=" + this.name + ", nameContains=" + this.nameContains + ", entityTypeName=" + this.entityTypeName + ", cloudResourceId=" + this.cloudResourceId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecycleDetailsContains=" + this.lifecycleDetailsContains + ", isManagementAgentIdNull=" + (Object)((Object)this.isManagementAgentIdNull) + ", hostname=" + this.hostname + ", hostnameContains=" + this.hostnameContains + ", sourceId=" + this.sourceId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsManagementAgentIdNull {
        True("true"),
        False("false");

        private final String value;
        private static Map<String, IsManagementAgentIdNull> map;

        private IsManagementAgentIdNull(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsManagementAgentIdNull create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsManagementAgentIdNull: " + key);
        }

        static {
            map = new HashMap<String, IsManagementAgentIdNull>();
            for (IsManagementAgentIdNull v : IsManagementAgentIdNull.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

