/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.loganalytics.model.EntityCloudType;
import com.oracle.bmc.loganalytics.model.EntityLifecycleStates;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLogAnalyticsEntityTypesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String name;
    private String nameContains;
    private EntityCloudType cloudType;
    private EntityLifecycleStates lifecycleState;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "name", "nameContains", "cloudType", "lifecycleState", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListLogAnalyticsEntityTypesRequest(String namespaceName, String name, String nameContains, EntityCloudType cloudType, EntityLifecycleStates lifecycleState, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.name = name;
        this.nameContains = nameContains;
        this.cloudType = cloudType;
        this.lifecycleState = lifecycleState;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getName() {
        return this.name;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public EntityCloudType getCloudType() {
        return this.cloudType;
    }

    public EntityLifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLogAnalyticsEntityTypesRequest, Void> {
        private String namespaceName;
        private String name;
        private String nameContains;
        private EntityCloudType cloudType;
        private EntityLifecycleStates lifecycleState;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLogAnalyticsEntityTypesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.name(o.getName());
            this.nameContains(o.getNameContains());
            this.cloudType(o.getCloudType());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLogAnalyticsEntityTypesRequest build() {
            ListLogAnalyticsEntityTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public Builder cloudType(EntityCloudType cloudType) {
            this.cloudType = cloudType;
            return this;
        }

        public Builder lifecycleState(EntityLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLogAnalyticsEntityTypesRequest buildWithoutInvocationCallback() {
            return new ListLogAnalyticsEntityTypesRequest(this.namespaceName, this.name, this.nameContains, this.cloudType, this.lifecycleState, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListLogAnalyticsEntityTypesRequest.Builder(namespaceName=" + this.namespaceName + ", name=" + this.name + ", nameContains=" + this.nameContains + ", cloudType=" + (Object)((Object)this.cloudType) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

