/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLookupsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private Type type;
    private String lookupDisplayText;
    private IsSystem isSystem;
    private SortBy sortBy;
    private Status status;
    private Boolean isHideSpecial;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "type", "lookupDisplayText", "isSystem", "sortBy", "status", "isHideSpecial", "limit", "page", "sortOrder", "opcRequestId"})
    ListLookupsRequest(String namespaceName, Type type, String lookupDisplayText, IsSystem isSystem, SortBy sortBy, Status status, Boolean isHideSpecial, Integer limit, String page, SortOrder sortOrder, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.type = type;
        this.lookupDisplayText = lookupDisplayText;
        this.isSystem = isSystem;
        this.sortBy = sortBy;
        this.status = status;
        this.isHideSpecial = isHideSpecial;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Type getType() {
        return this.type;
    }

    public String getLookupDisplayText() {
        return this.lookupDisplayText;
    }

    public IsSystem getIsSystem() {
        return this.isSystem;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Status getStatus() {
        return this.status;
    }

    public Boolean getIsHideSpecial() {
        return this.isHideSpecial;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLookupsRequest, Void> {
        private String namespaceName;
        private Type type;
        private String lookupDisplayText;
        private IsSystem isSystem;
        private SortBy sortBy;
        private Status status;
        private Boolean isHideSpecial;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLookupsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.type(o.getType());
            this.lookupDisplayText(o.getLookupDisplayText());
            this.isSystem(o.getIsSystem());
            this.sortBy(o.getSortBy());
            this.status(o.getStatus());
            this.isHideSpecial(o.getIsHideSpecial());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLookupsRequest build() {
            ListLookupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder lookupDisplayText(String lookupDisplayText) {
            this.lookupDisplayText = lookupDisplayText;
            return this;
        }

        public Builder isSystem(IsSystem isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder isHideSpecial(Boolean isHideSpecial) {
            this.isHideSpecial = isHideSpecial;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLookupsRequest buildWithoutInvocationCallback() {
            return new ListLookupsRequest(this.namespaceName, this.type, this.lookupDisplayText, this.isSystem, this.sortBy, this.status, this.isHideSpecial, this.limit, this.page, this.sortOrder, this.opcRequestId);
        }

        public String toString() {
            return "ListLookupsRequest.Builder(namespaceName=" + this.namespaceName + ", type=" + (Object)((Object)this.type) + ", lookupDisplayText=" + this.lookupDisplayText + ", isSystem=" + (Object)((Object)this.isSystem) + ", sortBy=" + (Object)((Object)this.sortBy) + ", status=" + (Object)((Object)this.status) + ", isHideSpecial=" + this.isHideSpecial + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status {
        All("ALL"),
        Succesful("SUCCESFUL"),
        Failed("FAILED"),
        Inprogress("INPROGRESS");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        Status("status"),
        Type("type"),
        UpdatedTime("updatedTime"),
        CreationType("creationType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystem {
        All("ALL"),
        Custom("CUSTOM"),
        BuiltIn("BUILT_IN");

        private final String value;
        private static Map<String, IsSystem> map;

        private IsSystem(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystem create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSystem: " + key);
        }

        static {
            map = new HashMap<String, IsSystem>();
            for (IsSystem v : IsSystem.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type {
        Lookup("Lookup"),
        Dictionary("Dictionary");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

