/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.loganalytics.model.TaskType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListScheduledTasksRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private TaskType taskType;
    private String compartmentId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private String displayName;
    private SortOrder sortOrder;
    private SortBy sortBy;

    @ConstructorProperties(value={"namespaceName", "taskType", "compartmentId", "opcRequestId", "limit", "page", "displayName", "sortOrder", "sortBy"})
    ListScheduledTasksRequest(String namespaceName, TaskType taskType, String compartmentId, String opcRequestId, Integer limit, String page, String displayName, SortOrder sortOrder, SortBy sortBy) {
        this.namespaceName = namespaceName;
        this.taskType = taskType;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.displayName = displayName;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public static class Builder
    implements BmcRequest.Builder<ListScheduledTasksRequest, Void> {
        private String namespaceName;
        private TaskType taskType;
        private String compartmentId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private String displayName;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListScheduledTasksRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.taskType(o.getTaskType());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.displayName(o.getDisplayName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListScheduledTasksRequest build() {
            ListScheduledTasksRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListScheduledTasksRequest buildWithoutInvocationCallback() {
            return new ListScheduledTasksRequest(this.namespaceName, this.taskType, this.compartmentId, this.opcRequestId, this.limit, this.page, this.displayName, this.sortOrder, this.sortBy);
        }

        public String toString() {
            return "ListScheduledTasksRequest.Builder(namespaceName=" + this.namespaceName + ", taskType=" + (Object)((Object)this.taskType) + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", displayName=" + this.displayName + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

