/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.TestParserPayloadDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class TestParserRequest
extends BmcRequest<TestParserPayloadDetails> {
    private String namespaceName;
    private TestParserPayloadDetails testParserPayloadDetails;
    private Scope scope;
    private String reqOriginModule;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public TestParserPayloadDetails getBody$() {
        return this.testParserPayloadDetails;
    }

    @ConstructorProperties(value={"namespaceName", "testParserPayloadDetails", "scope", "reqOriginModule", "opcRetryToken", "opcRequestId"})
    TestParserRequest(String namespaceName, TestParserPayloadDetails testParserPayloadDetails, Scope scope, String reqOriginModule, String opcRetryToken, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.testParserPayloadDetails = testParserPayloadDetails;
        this.scope = scope;
        this.reqOriginModule = reqOriginModule;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public TestParserPayloadDetails getTestParserPayloadDetails() {
        return this.testParserPayloadDetails;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getReqOriginModule() {
        return this.reqOriginModule;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<TestParserRequest, TestParserPayloadDetails> {
        private String namespaceName;
        private TestParserPayloadDetails testParserPayloadDetails;
        private Scope scope;
        private String reqOriginModule;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TestParserRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.testParserPayloadDetails(o.getTestParserPayloadDetails());
            this.scope(o.getScope());
            this.reqOriginModule(o.getReqOriginModule());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TestParserRequest build() {
            TestParserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TestParserPayloadDetails body) {
            this.testParserPayloadDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder testParserPayloadDetails(TestParserPayloadDetails testParserPayloadDetails) {
            this.testParserPayloadDetails = testParserPayloadDetails;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder reqOriginModule(String reqOriginModule) {
            this.reqOriginModule = reqOriginModule;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public TestParserRequest buildWithoutInvocationCallback() {
            return new TestParserRequest(this.namespaceName, this.testParserPayloadDetails, this.scope, this.reqOriginModule, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "TestParserRequest.Builder(namespaceName=" + this.namespaceName + ", testParserPayloadDetails=" + this.testParserPayloadDetails + ", scope=" + (Object)((Object)this.scope) + ", reqOriginModule=" + this.reqOriginModule + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum Scope {
        LogLines("LOG_LINES"),
        LogEntries("LOG_ENTRIES"),
        LogLinesLogEntries("LOG_LINES_LOG_ENTRIES");

        private final String value;
        private static Map<String, Scope> map;

        private Scope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Scope: " + key);
        }

        static {
            map = new HashMap<String, Scope>();
            for (Scope v : Scope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

