/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ValidateFileRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String objectLocation;
    private String filename;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "objectLocation", "filename", "opcRequestId"})
    ValidateFileRequest(String namespaceName, String objectLocation, String filename, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.objectLocation = objectLocation;
        this.filename = filename;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getObjectLocation() {
        return this.objectLocation;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateFileRequest, Void> {
        private String namespaceName;
        private String objectLocation;
        private String filename;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateFileRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.objectLocation(o.getObjectLocation());
            this.filename(o.getFilename());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateFileRequest build() {
            ValidateFileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder objectLocation(String objectLocation) {
            this.objectLocation = objectLocation;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ValidateFileRequest buildWithoutInvocationCallback() {
            return new ValidateFileRequest(this.namespaceName, this.objectLocation, this.filename, this.opcRequestId);
        }

        public String toString() {
            return "ValidateFileRequest.Builder(namespaceName=" + this.namespaceName + ", objectLocation=" + this.objectLocation + ", filename=" + this.filename + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

