/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.logging.LoggingManagement;
import com.oracle.bmc.logging.LoggingManagementPaginators;
import com.oracle.bmc.logging.LoggingManagementWaiters;
import com.oracle.bmc.logging.internal.http.ChangeLogGroupCompartmentConverter;
import com.oracle.bmc.logging.internal.http.ChangeLogLogGroupConverter;
import com.oracle.bmc.logging.internal.http.ChangeLogSavedSearchCompartmentConverter;
import com.oracle.bmc.logging.internal.http.ChangeUnifiedAgentConfigurationCompartmentConverter;
import com.oracle.bmc.logging.internal.http.CreateLogConverter;
import com.oracle.bmc.logging.internal.http.CreateLogGroupConverter;
import com.oracle.bmc.logging.internal.http.CreateLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.CreateUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.internal.http.DeleteLogConverter;
import com.oracle.bmc.logging.internal.http.DeleteLogGroupConverter;
import com.oracle.bmc.logging.internal.http.DeleteLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.DeleteUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.logging.internal.http.GetLogConverter;
import com.oracle.bmc.logging.internal.http.GetLogGroupConverter;
import com.oracle.bmc.logging.internal.http.GetLogIncludedSearchConverter;
import com.oracle.bmc.logging.internal.http.GetLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.GetUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.logging.internal.http.ListLogGroupsConverter;
import com.oracle.bmc.logging.internal.http.ListLogIncludedSearchesConverter;
import com.oracle.bmc.logging.internal.http.ListLogSavedSearchesConverter;
import com.oracle.bmc.logging.internal.http.ListLogsConverter;
import com.oracle.bmc.logging.internal.http.ListServicesConverter;
import com.oracle.bmc.logging.internal.http.ListUnifiedAgentConfigurationsConverter;
import com.oracle.bmc.logging.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.logging.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.logging.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.logging.internal.http.UpdateLogConverter;
import com.oracle.bmc.logging.internal.http.UpdateLogGroupConverter;
import com.oracle.bmc.logging.internal.http.UpdateLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.UpdateUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.requests.ChangeLogGroupCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeLogLogGroupRequest;
import com.oracle.bmc.logging.requests.ChangeLogSavedSearchCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeUnifiedAgentConfigurationCompartmentRequest;
import com.oracle.bmc.logging.requests.CreateLogGroupRequest;
import com.oracle.bmc.logging.requests.CreateLogRequest;
import com.oracle.bmc.logging.requests.CreateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.CreateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteLogGroupRequest;
import com.oracle.bmc.logging.requests.DeleteLogRequest;
import com.oracle.bmc.logging.requests.DeleteLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.DeleteUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.logging.requests.GetLogGroupRequest;
import com.oracle.bmc.logging.requests.GetLogIncludedSearchRequest;
import com.oracle.bmc.logging.requests.GetLogRequest;
import com.oracle.bmc.logging.requests.GetLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.GetUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.GetWorkRequestRequest;
import com.oracle.bmc.logging.requests.ListLogGroupsRequest;
import com.oracle.bmc.logging.requests.ListLogIncludedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogSavedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogsRequest;
import com.oracle.bmc.logging.requests.ListServicesRequest;
import com.oracle.bmc.logging.requests.ListUnifiedAgentConfigurationsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestsRequest;
import com.oracle.bmc.logging.requests.UpdateLogGroupRequest;
import com.oracle.bmc.logging.requests.UpdateLogRequest;
import com.oracle.bmc.logging.requests.UpdateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.UpdateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.responses.ChangeLogGroupCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeLogLogGroupResponse;
import com.oracle.bmc.logging.responses.ChangeLogSavedSearchCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeUnifiedAgentConfigurationCompartmentResponse;
import com.oracle.bmc.logging.responses.CreateLogGroupResponse;
import com.oracle.bmc.logging.responses.CreateLogResponse;
import com.oracle.bmc.logging.responses.CreateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.CreateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteLogGroupResponse;
import com.oracle.bmc.logging.responses.DeleteLogResponse;
import com.oracle.bmc.logging.responses.DeleteLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.DeleteUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.logging.responses.GetLogGroupResponse;
import com.oracle.bmc.logging.responses.GetLogIncludedSearchResponse;
import com.oracle.bmc.logging.responses.GetLogResponse;
import com.oracle.bmc.logging.responses.GetLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.GetUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.GetWorkRequestResponse;
import com.oracle.bmc.logging.responses.ListLogGroupsResponse;
import com.oracle.bmc.logging.responses.ListLogIncludedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogSavedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogsResponse;
import com.oracle.bmc.logging.responses.ListServicesResponse;
import com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestsResponse;
import com.oracle.bmc.logging.responses.UpdateLogGroupResponse;
import com.oracle.bmc.logging.responses.UpdateLogResponse;
import com.oracle.bmc.logging.responses.UpdateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.UpdateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingManagementClient
implements LoggingManagement {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingManagementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGGINGMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://logging.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final LoggingManagementWaiters waiters;
    private final LoggingManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public LoggingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LoggingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LoggingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LoggingManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LoggingManagementWaiters(executorService, this);
        this.paginators = new LoggingManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeLogGroupCompartmentResponse changeLogGroupCompartment(ChangeLogGroupCompartmentRequest request) {
        LOG.trace("Called changeLogGroupCompartment");
        ChangeLogGroupCompartmentRequest interceptedRequest = ChangeLogGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogGroupCompartmentResponse> transformer = ChangeLogGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeLogGroupCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLogGroupCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLogGroupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeLogGroupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeLogLogGroupResponse changeLogLogGroup(ChangeLogLogGroupRequest request) {
        LOG.trace("Called changeLogLogGroup");
        ChangeLogLogGroupRequest interceptedRequest = ChangeLogLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogLogGroupResponse> transformer = ChangeLogLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeLogLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLogLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLogLogGroupDetails(), (BmcRequest)retriedRequest);
                return (ChangeLogLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeLogSavedSearchCompartmentResponse changeLogSavedSearchCompartment(ChangeLogSavedSearchCompartmentRequest request) {
        LOG.trace("Called changeLogSavedSearchCompartment");
        ChangeLogSavedSearchCompartmentRequest interceptedRequest = ChangeLogSavedSearchCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogSavedSearchCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogSavedSearchCompartmentResponse> transformer = ChangeLogSavedSearchCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeLogSavedSearchCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLogSavedSearchCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLogSavedSearchCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeLogSavedSearchCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeUnifiedAgentConfigurationCompartmentResponse changeUnifiedAgentConfigurationCompartment(ChangeUnifiedAgentConfigurationCompartmentRequest request) {
        LOG.trace("Called changeUnifiedAgentConfigurationCompartment");
        ChangeUnifiedAgentConfigurationCompartmentRequest interceptedRequest = ChangeUnifiedAgentConfigurationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeUnifiedAgentConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeUnifiedAgentConfigurationCompartmentResponse> transformer = ChangeUnifiedAgentConfigurationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeUnifiedAgentConfigurationCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeUnifiedAgentConfigurationCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeUnifiedAgentConfigurationCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeUnifiedAgentConfigurationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogResponse createLog(CreateLogRequest request) {
        LOG.trace("Called createLog");
        CreateLogRequest interceptedRequest = CreateLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogResponse> transformer = CreateLogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogDetails(), (BmcRequest)retriedRequest);
                return (CreateLogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogGroupResponse createLogGroup(CreateLogGroupRequest request) {
        LOG.trace("Called createLogGroup");
        CreateLogGroupRequest interceptedRequest = CreateLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogGroupResponse> transformer = CreateLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogSavedSearchResponse createLogSavedSearch(CreateLogSavedSearchRequest request) {
        LOG.trace("Called createLogSavedSearch");
        CreateLogSavedSearchRequest interceptedRequest = CreateLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogSavedSearchResponse> transformer = CreateLogSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLogSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogSavedSearchDetails(), (BmcRequest)retriedRequest);
                return (CreateLogSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateUnifiedAgentConfigurationResponse createUnifiedAgentConfiguration(CreateUnifiedAgentConfigurationRequest request) {
        LOG.trace("Called createUnifiedAgentConfiguration");
        CreateUnifiedAgentConfigurationRequest interceptedRequest = CreateUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateUnifiedAgentConfigurationResponse> transformer = CreateUnifiedAgentConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateUnifiedAgentConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateUnifiedAgentConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateUnifiedAgentConfigurationDetails(), (BmcRequest)retriedRequest);
                return (CreateUnifiedAgentConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogResponse deleteLog(DeleteLogRequest request) {
        LOG.trace("Called deleteLog");
        DeleteLogRequest interceptedRequest = DeleteLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogResponse> transformer = DeleteLogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogGroupResponse deleteLogGroup(DeleteLogGroupRequest request) {
        LOG.trace("Called deleteLogGroup");
        DeleteLogGroupRequest interceptedRequest = DeleteLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogGroupResponse> transformer = DeleteLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogSavedSearchResponse deleteLogSavedSearch(DeleteLogSavedSearchRequest request) {
        LOG.trace("Called deleteLogSavedSearch");
        DeleteLogSavedSearchRequest interceptedRequest = DeleteLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogSavedSearchResponse> transformer = DeleteLogSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteUnifiedAgentConfigurationResponse deleteUnifiedAgentConfiguration(DeleteUnifiedAgentConfigurationRequest request) {
        LOG.trace("Called deleteUnifiedAgentConfiguration");
        DeleteUnifiedAgentConfigurationRequest interceptedRequest = DeleteUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteUnifiedAgentConfigurationResponse> transformer = DeleteUnifiedAgentConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteUnifiedAgentConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteUnifiedAgentConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteUnifiedAgentConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        LOG.trace("Called deleteWorkRequest");
        DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogResponse getLog(GetLogRequest request) {
        LOG.trace("Called getLog");
        GetLogRequest interceptedRequest = GetLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogResponse> transformer = GetLogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogGroupResponse getLogGroup(GetLogGroupRequest request) {
        LOG.trace("Called getLogGroup");
        GetLogGroupRequest interceptedRequest = GetLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogGroupResponse> transformer = GetLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogIncludedSearchResponse getLogIncludedSearch(GetLogIncludedSearchRequest request) {
        LOG.trace("Called getLogIncludedSearch");
        GetLogIncludedSearchRequest interceptedRequest = GetLogIncludedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogIncludedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogIncludedSearchResponse> transformer = GetLogIncludedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogIncludedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogIncludedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogIncludedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogSavedSearchResponse getLogSavedSearch(GetLogSavedSearchRequest request) {
        LOG.trace("Called getLogSavedSearch");
        GetLogSavedSearchRequest interceptedRequest = GetLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogSavedSearchResponse> transformer = GetLogSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetUnifiedAgentConfigurationResponse getUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request) {
        LOG.trace("Called getUnifiedAgentConfiguration");
        GetUnifiedAgentConfigurationRequest interceptedRequest = GetUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUnifiedAgentConfigurationResponse> transformer = GetUnifiedAgentConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetUnifiedAgentConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetUnifiedAgentConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetUnifiedAgentConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogGroupsResponse listLogGroups(ListLogGroupsRequest request) {
        LOG.trace("Called listLogGroups");
        ListLogGroupsRequest interceptedRequest = ListLogGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogGroupsResponse> transformer = ListLogGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogIncludedSearchesResponse listLogIncludedSearches(ListLogIncludedSearchesRequest request) {
        LOG.trace("Called listLogIncludedSearches");
        ListLogIncludedSearchesRequest interceptedRequest = ListLogIncludedSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogIncludedSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogIncludedSearchesResponse> transformer = ListLogIncludedSearchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogIncludedSearchesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogIncludedSearchesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogIncludedSearchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogSavedSearchesResponse listLogSavedSearches(ListLogSavedSearchesRequest request) {
        LOG.trace("Called listLogSavedSearches");
        ListLogSavedSearchesRequest interceptedRequest = ListLogSavedSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogSavedSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogSavedSearchesResponse> transformer = ListLogSavedSearchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogSavedSearchesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogSavedSearchesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogSavedSearchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogsResponse listLogs(ListLogsRequest request) {
        LOG.trace("Called listLogs");
        ListLogsRequest interceptedRequest = ListLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogsResponse> transformer = ListLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListServicesResponse listServices(ListServicesRequest request) {
        LOG.trace("Called listServices");
        ListServicesRequest interceptedRequest = ListServicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListServicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListServicesResponse> transformer = ListServicesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListServicesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListServicesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListServicesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListUnifiedAgentConfigurationsResponse listUnifiedAgentConfigurations(ListUnifiedAgentConfigurationsRequest request) {
        LOG.trace("Called listUnifiedAgentConfigurations");
        ListUnifiedAgentConfigurationsRequest interceptedRequest = ListUnifiedAgentConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUnifiedAgentConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUnifiedAgentConfigurationsResponse> transformer = ListUnifiedAgentConfigurationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListUnifiedAgentConfigurationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUnifiedAgentConfigurationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUnifiedAgentConfigurationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogResponse updateLog(UpdateLogRequest request) {
        LOG.trace("Called updateLog");
        UpdateLogRequest interceptedRequest = UpdateLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogResponse> transformer = UpdateLogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogGroupResponse updateLogGroup(UpdateLogGroupRequest request) {
        LOG.trace("Called updateLogGroup");
        UpdateLogGroupRequest interceptedRequest = UpdateLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogGroupResponse> transformer = UpdateLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogSavedSearchResponse updateLogSavedSearch(UpdateLogSavedSearchRequest request) {
        LOG.trace("Called updateLogSavedSearch");
        UpdateLogSavedSearchRequest interceptedRequest = UpdateLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogSavedSearchResponse> transformer = UpdateLogSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogSavedSearchDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateUnifiedAgentConfigurationResponse updateUnifiedAgentConfiguration(UpdateUnifiedAgentConfigurationRequest request) {
        LOG.trace("Called updateUnifiedAgentConfiguration");
        UpdateUnifiedAgentConfigurationRequest interceptedRequest = UpdateUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateUnifiedAgentConfigurationResponse> transformer = UpdateUnifiedAgentConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateUnifiedAgentConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateUnifiedAgentConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateUnifiedAgentConfigurationDetails(), (BmcRequest)retriedRequest);
                return (UpdateUnifiedAgentConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LoggingManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LoggingManagementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoggingManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LoggingManagementClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new LoggingManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

