/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.logging.model.Log;
import com.oracle.bmc.logging.requests.GetLogRequest;
import com.oracle.bmc.logging.responses.GetLogResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLogConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetLogConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetLogRequest interceptRequest(GetLogRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetLogRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200531").path("logGroups").path(HttpUtils.encodePathSegment((String)request.getLogGroupId())).path("logs").path(HttpUtils.encodePathSegment((String)request.getLogId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetLogResponse> fromResponse() {
        Function<Response, GetLogResponse> transformer = new Function<Response, GetLogResponse>(){

            public GetLogResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.logging.responses.GetLogResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Log.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetLogResponse.Builder builder = GetLogResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.log((Log)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                GetLogResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

