/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.logging.model.LogIncludedSearchSummaryCollection;
import com.oracle.bmc.logging.requests.ListLogIncludedSearchesRequest;
import com.oracle.bmc.logging.responses.ListLogIncludedSearchesResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListLogIncludedSearchesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListLogIncludedSearchesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListLogIncludedSearchesRequest interceptRequest(ListLogIncludedSearchesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListLogIncludedSearchesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200531").path("logIncludedSearches");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLogIncludedSearchId() != null) {
            target = target.queryParam("logIncludedSearchId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLogIncludedSearchId())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListLogIncludedSearchesResponse> fromResponse() {
        Function<Response, ListLogIncludedSearchesResponse> transformer = new Function<Response, ListLogIncludedSearchesResponse>(){

            public ListLogIncludedSearchesResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcPreviousPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.logging.responses.ListLogIncludedSearchesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogIncludedSearchSummaryCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListLogIncludedSearchesResponse.Builder builder = ListLogIncludedSearchesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logIncludedSearchSummaryCollection((LogIncludedSearchSummaryCollection)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPreviousPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-previous-page")).isPresent()) {
                    builder.opcPreviousPage((String)HeaderUtils.toValue((String)"opc-previous-page", (String)((String)((List)opcPreviousPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListLogIncludedSearchesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

