/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.Configuration;
import com.oracle.bmc.logging.model.LogLifecycleState;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Log {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="logGroupId")
    private final String logGroupId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="logType")
    private final LogType logType;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="configuration")
    private final Configuration configuration;
    @JsonProperty(value="lifecycleState")
    private final LogLifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;
    @JsonProperty(value="retentionDuration")
    private final Integer retentionDuration;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).tenancyId(this.tenancyId).logGroupId(this.logGroupId).displayName(this.displayName).logType(this.logType).isEnabled(this.isEnabled).definedTags(this.definedTags).freeformTags(this.freeformTags).configuration(this.configuration).lifecycleState(this.lifecycleState).timeCreated(this.timeCreated).timeLastModified(this.timeLastModified).retentionDuration(this.retentionDuration).compartmentId(this.compartmentId);
    }

    public String getId() {
        return this.id;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LogType getLogType() {
        return this.logType;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public LogLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public Integer getRetentionDuration() {
        return this.retentionDuration;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log other = (Log)o;
        Boolean this$isEnabled = this.getIsEnabled();
        Boolean other$isEnabled = other.getIsEnabled();
        if (this$isEnabled == null ? other$isEnabled != null : !((Object)this$isEnabled).equals(other$isEnabled)) {
            return false;
        }
        Integer this$retentionDuration = this.getRetentionDuration();
        Integer other$retentionDuration = other.getRetentionDuration();
        if (this$retentionDuration == null ? other$retentionDuration != null : !((Object)this$retentionDuration).equals(other$retentionDuration)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenancyId = this.getTenancyId();
        String other$tenancyId = other.getTenancyId();
        if (this$tenancyId == null ? other$tenancyId != null : !this$tenancyId.equals(other$tenancyId)) {
            return false;
        }
        String this$logGroupId = this.getLogGroupId();
        String other$logGroupId = other.getLogGroupId();
        if (this$logGroupId == null ? other$logGroupId != null : !this$logGroupId.equals(other$logGroupId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        LogType this$logType = this.getLogType();
        LogType other$logType = other.getLogType();
        if (this$logType == null ? other$logType != null : !((Object)((Object)this$logType)).equals((Object)other$logType)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        LogLifecycleState this$lifecycleState = this.getLifecycleState();
        LogLifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeLastModified = this.getTimeLastModified();
        Date other$timeLastModified = other.getTimeLastModified();
        if (this$timeLastModified == null ? other$timeLastModified != null : !((Object)this$timeLastModified).equals(other$timeLastModified)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isEnabled = this.getIsEnabled();
        result = result * 59 + ($isEnabled == null ? 43 : ((Object)$isEnabled).hashCode());
        Integer $retentionDuration = this.getRetentionDuration();
        result = result * 59 + ($retentionDuration == null ? 43 : ((Object)$retentionDuration).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenancyId = this.getTenancyId();
        result = result * 59 + ($tenancyId == null ? 43 : $tenancyId.hashCode());
        String $logGroupId = this.getLogGroupId();
        result = result * 59 + ($logGroupId == null ? 43 : $logGroupId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        LogType $logType = this.getLogType();
        result = result * 59 + ($logType == null ? 43 : ((Object)((Object)$logType)).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        LogLifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeLastModified = this.getTimeLastModified();
        result = result * 59 + ($timeLastModified == null ? 43 : ((Object)$timeLastModified).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Log(id=" + this.getId() + ", tenancyId=" + this.getTenancyId() + ", logGroupId=" + this.getLogGroupId() + ", displayName=" + this.getDisplayName() + ", logType=" + (Object)((Object)this.getLogType()) + ", isEnabled=" + this.getIsEnabled() + ", definedTags=" + this.getDefinedTags() + ", freeformTags=" + this.getFreeformTags() + ", configuration=" + this.getConfiguration() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", timeCreated=" + this.getTimeCreated() + ", timeLastModified=" + this.getTimeLastModified() + ", retentionDuration=" + this.getRetentionDuration() + ", compartmentId=" + this.getCompartmentId() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "tenancyId", "logGroupId", "displayName", "logType", "isEnabled", "definedTags", "freeformTags", "configuration", "lifecycleState", "timeCreated", "timeLastModified", "retentionDuration", "compartmentId"})
    @Deprecated
    public Log(String id, String tenancyId, String logGroupId, String displayName, LogType logType, Boolean isEnabled, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, Configuration configuration, LogLifecycleState lifecycleState, Date timeCreated, Date timeLastModified, Integer retentionDuration, String compartmentId) {
        this.id = id;
        this.tenancyId = tenancyId;
        this.logGroupId = logGroupId;
        this.displayName = displayName;
        this.logType = logType;
        this.isEnabled = isEnabled;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
        this.configuration = configuration;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeLastModified = timeLastModified;
        this.retentionDuration = retentionDuration;
        this.compartmentId = compartmentId;
    }

    public static enum LogType {
        Custom("CUSTOM"),
        Service("SERVICE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LogType> map;

        private LogType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LogType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LogType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LogType.class);
            map = new HashMap<String, LogType>();
            for (LogType v : LogType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="logGroupId")
        private String logGroupId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="logType")
        private LogType logType;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="configuration")
        private Configuration configuration;
        @JsonProperty(value="lifecycleState")
        private LogLifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonProperty(value="retentionDuration")
        private Integer retentionDuration;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            this.__explicitlySet__.add("logGroupId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder logType(LogType logType) {
            this.logType = logType;
            this.__explicitlySet__.add("logType");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            this.__explicitlySet__.add("configuration");
            return this;
        }

        public Builder lifecycleState(LogLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public Builder retentionDuration(Integer retentionDuration) {
            this.retentionDuration = retentionDuration;
            this.__explicitlySet__.add("retentionDuration");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Log build() {
            Log __instance__ = new Log(this.id, this.tenancyId, this.logGroupId, this.displayName, this.logType, this.isEnabled, this.definedTags, this.freeformTags, this.configuration, this.lifecycleState, this.timeCreated, this.timeLastModified, this.retentionDuration, this.compartmentId);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Log o) {
            Builder copiedBuilder = this.id(o.getId()).tenancyId(o.getTenancyId()).logGroupId(o.getLogGroupId()).displayName(o.getDisplayName()).logType(o.getLogType()).isEnabled(o.getIsEnabled()).definedTags(o.getDefinedTags()).freeformTags(o.getFreeformTags()).configuration(o.getConfiguration()).lifecycleState(o.getLifecycleState()).timeCreated(o.getTimeCreated()).timeLastModified(o.getTimeLastModified()).retentionDuration(o.getRetentionDuration()).compartmentId(o.getCompartmentId());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Log.Builder(id=" + this.id + ", tenancyId=" + this.tenancyId + ", logGroupId=" + this.logGroupId + ", displayName=" + this.displayName + ", logType=" + (Object)((Object)this.logType) + ", isEnabled=" + this.isEnabled + ", definedTags=" + this.definedTags + ", freeformTags=" + this.freeformTags + ", configuration=" + this.configuration + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", timeCreated=" + this.timeCreated + ", timeLastModified=" + this.timeLastModified + ", retentionDuration=" + this.retentionDuration + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

