/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetLogSavedSearchRequest
extends BmcRequest<Void> {
    private String logSavedSearchId;
    private String opcRequestId;

    @ConstructorProperties(value={"logSavedSearchId", "opcRequestId"})
    GetLogSavedSearchRequest(String logSavedSearchId, String opcRequestId) {
        this.logSavedSearchId = logSavedSearchId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLogSavedSearchId() {
        return this.logSavedSearchId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogSavedSearchRequest, Void> {
        private String logSavedSearchId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogSavedSearchRequest o) {
            this.logSavedSearchId(o.getLogSavedSearchId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogSavedSearchRequest build() {
            GetLogSavedSearchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder logSavedSearchId(String logSavedSearchId) {
            this.logSavedSearchId = logSavedSearchId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetLogSavedSearchRequest buildWithoutInvocationCallback() {
            return new GetLogSavedSearchRequest(this.logSavedSearchId, this.opcRequestId);
        }

        public String toString() {
            return "GetLogSavedSearchRequest.Builder(logSavedSearchId=" + this.logSavedSearchId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

