/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLogIncludedSearchesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String logIncludedSearchId;
    private String displayName;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "logIncludedSearchId", "displayName", "page", "limit", "sortBy", "sortOrder", "opcRequestId"})
    ListLogIncludedSearchesRequest(String compartmentId, String logIncludedSearchId, String displayName, String page, Integer limit, SortBy sortBy, SortOrder sortOrder, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.logIncludedSearchId = logIncludedSearchId;
        this.displayName = displayName;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getLogIncludedSearchId() {
        return this.logIncludedSearchId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLogIncludedSearchesRequest, Void> {
        private String compartmentId;
        private String logIncludedSearchId;
        private String displayName;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLogIncludedSearchesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.logIncludedSearchId(o.getLogIncludedSearchId());
            this.displayName(o.getDisplayName());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLogIncludedSearchesRequest build() {
            ListLogIncludedSearchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder logIncludedSearchId(String logIncludedSearchId) {
            this.logIncludedSearchId = logIncludedSearchId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLogIncludedSearchesRequest buildWithoutInvocationCallback() {
            return new ListLogIncludedSearchesRequest(this.compartmentId, this.logIncludedSearchId, this.displayName, this.page, this.limit, this.sortBy, this.sortOrder, this.opcRequestId);
        }

        public String toString() {
            return "ListLogIncludedSearchesRequest.Builder(compartmentId=" + this.compartmentId + ", logIncludedSearchId=" + this.logIncludedSearchId + ", displayName=" + this.displayName + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

