/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.logging.model.LogLifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLogsRequest
extends BmcRequest<Void> {
    private String logGroupId;
    private LogType logType;
    private String sourceService;
    private String sourceResource;
    private String displayName;
    private LogLifecycleState lifecycleState;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    @ConstructorProperties(value={"logGroupId", "logType", "sourceService", "sourceResource", "displayName", "lifecycleState", "page", "limit", "sortBy", "sortOrder", "opcRequestId"})
    ListLogsRequest(String logGroupId, LogType logType, String sourceService, String sourceResource, String displayName, LogLifecycleState lifecycleState, String page, Integer limit, SortBy sortBy, SortOrder sortOrder, String opcRequestId) {
        this.logGroupId = logGroupId;
        this.logType = logType;
        this.sourceService = sourceService;
        this.sourceResource = sourceResource;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public LogType getLogType() {
        return this.logType;
    }

    public String getSourceService() {
        return this.sourceService;
    }

    public String getSourceResource() {
        return this.sourceResource;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LogLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLogsRequest, Void> {
        private String logGroupId;
        private LogType logType;
        private String sourceService;
        private String sourceResource;
        private String displayName;
        private LogLifecycleState lifecycleState;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLogsRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.logType(o.getLogType());
            this.sourceService(o.getSourceService());
            this.sourceResource(o.getSourceResource());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLogsRequest build() {
            ListLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder logType(LogType logType) {
            this.logType = logType;
            return this;
        }

        public Builder sourceService(String sourceService) {
            this.sourceService = sourceService;
            return this;
        }

        public Builder sourceResource(String sourceResource) {
            this.sourceResource = sourceResource;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(LogLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLogsRequest buildWithoutInvocationCallback() {
            return new ListLogsRequest(this.logGroupId, this.logType, this.sourceService, this.sourceResource, this.displayName, this.lifecycleState, this.page, this.limit, this.sortBy, this.sortOrder, this.opcRequestId);
        }

        public String toString() {
            return "ListLogsRequest.Builder(logGroupId=" + this.logGroupId + ", logType=" + (Object)((Object)this.logType) + ", sourceService=" + this.sourceService + ", sourceResource=" + this.sourceResource + ", displayName=" + this.displayName + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LogType {
        Custom("CUSTOM"),
        Service("SERVICE");

        private final String value;
        private static Map<String, LogType> map;

        private LogType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LogType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LogType: " + key);
        }

        static {
            map = new HashMap<String, LogType>();
            for (LogType v : LogType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

