/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.managementdashboard.DashxApis;
import com.oracle.bmc.managementdashboard.DashxApisPaginators;
import com.oracle.bmc.managementdashboard.internal.http.ChangeManagementDashboardsCompartmentConverter;
import com.oracle.bmc.managementdashboard.internal.http.ChangeManagementSavedSearchesCompartmentConverter;
import com.oracle.bmc.managementdashboard.internal.http.CreateManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.CreateManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.internal.http.DeleteManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.DeleteManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.internal.http.ExportDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.GetManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.GetManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.internal.http.ImportDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.ListManagementDashboardsConverter;
import com.oracle.bmc.managementdashboard.internal.http.ListManagementSavedSearchesConverter;
import com.oracle.bmc.managementdashboard.internal.http.UpdateManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.UpdateManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementDashboardsCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementSavedSearchesCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ExportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ImportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementDashboardsRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementSavedSearchesRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementDashboardsCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementSavedSearchesCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ExportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ImportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementDashboardsResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementSavedSearchesResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementSavedSearchResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashxApisClient
implements DashxApis {
    private static final Logger LOG = LoggerFactory.getLogger(DashxApisClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DASHXAPIS").serviceEndpointPrefix("").serviceEndpointTemplate("https://managementdashboard.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DashxApisPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DashxApisClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DashxApisClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DashxApisClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    protected DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        this.paginators = new DashxApisPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeManagementDashboardsCompartmentResponse changeManagementDashboardsCompartment(ChangeManagementDashboardsCompartmentRequest request) {
        LOG.trace("Called changeManagementDashboardsCompartment");
        ChangeManagementDashboardsCompartmentRequest interceptedRequest = ChangeManagementDashboardsCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagementDashboardsCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagementDashboardsCompartmentResponse> transformer = ChangeManagementDashboardsCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeManagementDashboardsCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagementDashboardsCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagementDashboardsCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagementDashboardsCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeManagementSavedSearchesCompartmentResponse changeManagementSavedSearchesCompartment(ChangeManagementSavedSearchesCompartmentRequest request) {
        LOG.trace("Called changeManagementSavedSearchesCompartment");
        ChangeManagementSavedSearchesCompartmentRequest interceptedRequest = ChangeManagementSavedSearchesCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagementSavedSearchesCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagementSavedSearchesCompartmentResponse> transformer = ChangeManagementSavedSearchesCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeManagementSavedSearchesCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagementSavedSearchesCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagementSavedSearchesCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagementSavedSearchesCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateManagementDashboardResponse createManagementDashboard(CreateManagementDashboardRequest request) {
        LOG.trace("Called createManagementDashboard");
        CreateManagementDashboardRequest interceptedRequest = CreateManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagementDashboardResponse> transformer = CreateManagementDashboardConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateManagementDashboardResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagementDashboardResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagementDashboardDetails(), (BmcRequest)retriedRequest);
                return (CreateManagementDashboardResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateManagementSavedSearchResponse createManagementSavedSearch(CreateManagementSavedSearchRequest request) {
        LOG.trace("Called createManagementSavedSearch");
        CreateManagementSavedSearchRequest interceptedRequest = CreateManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagementSavedSearchResponse> transformer = CreateManagementSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateManagementSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagementSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagementSavedSearchDetails(), (BmcRequest)retriedRequest);
                return (CreateManagementSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteManagementDashboardResponse deleteManagementDashboard(DeleteManagementDashboardRequest request) {
        LOG.trace("Called deleteManagementDashboard");
        DeleteManagementDashboardRequest interceptedRequest = DeleteManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagementDashboardResponse> transformer = DeleteManagementDashboardConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteManagementDashboardResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagementDashboardResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagementDashboardResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteManagementSavedSearchResponse deleteManagementSavedSearch(DeleteManagementSavedSearchRequest request) {
        LOG.trace("Called deleteManagementSavedSearch");
        DeleteManagementSavedSearchRequest interceptedRequest = DeleteManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagementSavedSearchResponse> transformer = DeleteManagementSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteManagementSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagementSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagementSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExportDashboardResponse exportDashboard(ExportDashboardRequest request) {
        LOG.trace("Called exportDashboard");
        ExportDashboardRequest interceptedRequest = ExportDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExportDashboardResponse> transformer = ExportDashboardConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExportDashboardResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExportDashboardResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ExportDashboardResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetManagementDashboardResponse getManagementDashboard(GetManagementDashboardRequest request) {
        LOG.trace("Called getManagementDashboard");
        GetManagementDashboardRequest interceptedRequest = GetManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagementDashboardResponse> transformer = GetManagementDashboardConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GetManagementDashboardResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagementDashboardResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagementDashboardResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetManagementSavedSearchResponse getManagementSavedSearch(GetManagementSavedSearchRequest request) {
        LOG.trace("Called getManagementSavedSearch");
        GetManagementSavedSearchRequest interceptedRequest = GetManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagementSavedSearchResponse> transformer = GetManagementSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GetManagementSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagementSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagementSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ImportDashboardResponse importDashboard(ImportDashboardRequest request) {
        LOG.trace("Called importDashboard");
        ImportDashboardRequest interceptedRequest = ImportDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportDashboardResponse> transformer = ImportDashboardConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ImportDashboardResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ImportDashboardResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getManagementDashboardImportDetails(), (BmcRequest)retriedRequest);
                return (ImportDashboardResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListManagementDashboardsResponse listManagementDashboards(ListManagementDashboardsRequest request) {
        LOG.trace("Called listManagementDashboards");
        ListManagementDashboardsRequest interceptedRequest = ListManagementDashboardsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagementDashboardsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagementDashboardsResponse> transformer = ListManagementDashboardsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListManagementDashboardsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagementDashboardsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagementDashboardsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListManagementSavedSearchesResponse listManagementSavedSearches(ListManagementSavedSearchesRequest request) {
        LOG.trace("Called listManagementSavedSearches");
        ListManagementSavedSearchesRequest interceptedRequest = ListManagementSavedSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagementSavedSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagementSavedSearchesResponse> transformer = ListManagementSavedSearchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListManagementSavedSearchesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagementSavedSearchesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagementSavedSearchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateManagementDashboardResponse updateManagementDashboard(UpdateManagementDashboardRequest request) {
        LOG.trace("Called updateManagementDashboard");
        UpdateManagementDashboardRequest interceptedRequest = UpdateManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagementDashboardResponse> transformer = UpdateManagementDashboardConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateManagementDashboardResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagementDashboardResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagementDashboardDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagementDashboardResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateManagementSavedSearchResponse updateManagementSavedSearch(UpdateManagementSavedSearchRequest request) {
        LOG.trace("Called updateManagementSavedSearch");
        UpdateManagementSavedSearchRequest interceptedRequest = UpdateManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagementSavedSearchResponse> transformer = UpdateManagementSavedSearchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateManagementSavedSearchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagementSavedSearchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagementSavedSearchDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagementSavedSearchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DashxApisPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DashxApisClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DashxApisClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DashxApisClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

