/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.marketplace.Marketplace;
import com.oracle.bmc.marketplace.MarketplacePaginators;
import com.oracle.bmc.marketplace.MarketplaceWaiters;
import com.oracle.bmc.marketplace.internal.http.ChangePublicationCompartmentConverter;
import com.oracle.bmc.marketplace.internal.http.CreateAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.CreatePublicationConverter;
import com.oracle.bmc.marketplace.internal.http.DeleteAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.DeletePublicationConverter;
import com.oracle.bmc.marketplace.internal.http.GetAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.GetAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.GetListingConverter;
import com.oracle.bmc.marketplace.internal.http.GetPackageConverter;
import com.oracle.bmc.marketplace.internal.http.GetPublicationConverter;
import com.oracle.bmc.marketplace.internal.http.GetPublicationPackageConverter;
import com.oracle.bmc.marketplace.internal.http.ListAcceptedAgreementsConverter;
import com.oracle.bmc.marketplace.internal.http.ListAgreementsConverter;
import com.oracle.bmc.marketplace.internal.http.ListCategoriesConverter;
import com.oracle.bmc.marketplace.internal.http.ListListingsConverter;
import com.oracle.bmc.marketplace.internal.http.ListPackagesConverter;
import com.oracle.bmc.marketplace.internal.http.ListPublicationPackagesConverter;
import com.oracle.bmc.marketplace.internal.http.ListPublicationsConverter;
import com.oracle.bmc.marketplace.internal.http.ListPublishersConverter;
import com.oracle.bmc.marketplace.internal.http.ListReportTypesConverter;
import com.oracle.bmc.marketplace.internal.http.ListReportsConverter;
import com.oracle.bmc.marketplace.internal.http.ListTaxesConverter;
import com.oracle.bmc.marketplace.internal.http.UpdateAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.UpdatePublicationConverter;
import com.oracle.bmc.marketplace.requests.ChangePublicationCompartmentRequest;
import com.oracle.bmc.marketplace.requests.CreateAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.CreatePublicationRequest;
import com.oracle.bmc.marketplace.requests.DeleteAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.DeletePublicationRequest;
import com.oracle.bmc.marketplace.requests.GetAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.GetAgreementRequest;
import com.oracle.bmc.marketplace.requests.GetListingRequest;
import com.oracle.bmc.marketplace.requests.GetPackageRequest;
import com.oracle.bmc.marketplace.requests.GetPublicationPackageRequest;
import com.oracle.bmc.marketplace.requests.GetPublicationRequest;
import com.oracle.bmc.marketplace.requests.ListAcceptedAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListCategoriesRequest;
import com.oracle.bmc.marketplace.requests.ListListingsRequest;
import com.oracle.bmc.marketplace.requests.ListPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationsRequest;
import com.oracle.bmc.marketplace.requests.ListPublishersRequest;
import com.oracle.bmc.marketplace.requests.ListReportTypesRequest;
import com.oracle.bmc.marketplace.requests.ListReportsRequest;
import com.oracle.bmc.marketplace.requests.ListTaxesRequest;
import com.oracle.bmc.marketplace.requests.UpdateAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.UpdatePublicationRequest;
import com.oracle.bmc.marketplace.responses.ChangePublicationCompartmentResponse;
import com.oracle.bmc.marketplace.responses.CreateAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.CreatePublicationResponse;
import com.oracle.bmc.marketplace.responses.DeleteAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.DeletePublicationResponse;
import com.oracle.bmc.marketplace.responses.GetAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.GetAgreementResponse;
import com.oracle.bmc.marketplace.responses.GetListingResponse;
import com.oracle.bmc.marketplace.responses.GetPackageResponse;
import com.oracle.bmc.marketplace.responses.GetPublicationPackageResponse;
import com.oracle.bmc.marketplace.responses.GetPublicationResponse;
import com.oracle.bmc.marketplace.responses.ListAcceptedAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListCategoriesResponse;
import com.oracle.bmc.marketplace.responses.ListListingsResponse;
import com.oracle.bmc.marketplace.responses.ListPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationsResponse;
import com.oracle.bmc.marketplace.responses.ListPublishersResponse;
import com.oracle.bmc.marketplace.responses.ListReportTypesResponse;
import com.oracle.bmc.marketplace.responses.ListReportsResponse;
import com.oracle.bmc.marketplace.responses.ListTaxesResponse;
import com.oracle.bmc.marketplace.responses.UpdateAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.UpdatePublicationResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceClient
implements Marketplace {
    private static final Logger LOG = LoggerFactory.getLogger(MarketplaceClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MARKETPLACE").serviceEndpointPrefix("").serviceEndpointTemplate("https://marketplace.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final MarketplaceWaiters waiters;
    private final MarketplacePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public MarketplaceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public MarketplaceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public MarketplaceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public MarketplaceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public MarketplaceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public MarketplaceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public MarketplaceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public MarketplaceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected MarketplaceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Marketplace-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new MarketplaceWaiters(executorService, this);
        this.paginators = new MarketplacePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangePublicationCompartmentResponse changePublicationCompartment(ChangePublicationCompartmentRequest request) {
        LOG.trace("Called changePublicationCompartment");
        ChangePublicationCompartmentRequest interceptedRequest = ChangePublicationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePublicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePublicationCompartmentResponse> transformer = ChangePublicationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangePublicationCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangePublicationCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangePublicationCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangePublicationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAcceptedAgreementResponse createAcceptedAgreement(CreateAcceptedAgreementRequest request) {
        LOG.trace("Called createAcceptedAgreement");
        CreateAcceptedAgreementRequest interceptedRequest = CreateAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAcceptedAgreementResponse> transformer = CreateAcceptedAgreementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAcceptedAgreementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAcceptedAgreementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAcceptedAgreementDetails(), (BmcRequest)retriedRequest);
                return (CreateAcceptedAgreementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePublicationResponse createPublication(CreatePublicationRequest request) {
        LOG.trace("Called createPublication");
        CreatePublicationRequest interceptedRequest = CreatePublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePublicationResponse> transformer = CreatePublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePublicationDetails(), (BmcRequest)retriedRequest);
                return (CreatePublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAcceptedAgreementResponse deleteAcceptedAgreement(DeleteAcceptedAgreementRequest request) {
        LOG.trace("Called deleteAcceptedAgreement");
        DeleteAcceptedAgreementRequest interceptedRequest = DeleteAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAcceptedAgreementResponse> transformer = DeleteAcceptedAgreementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteAcceptedAgreementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAcceptedAgreementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAcceptedAgreementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePublicationResponse deletePublication(DeletePublicationRequest request) {
        LOG.trace("Called deletePublication");
        DeletePublicationRequest interceptedRequest = DeletePublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePublicationResponse> transformer = DeletePublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAcceptedAgreementResponse getAcceptedAgreement(GetAcceptedAgreementRequest request) {
        LOG.trace("Called getAcceptedAgreement");
        GetAcceptedAgreementRequest interceptedRequest = GetAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAcceptedAgreementResponse> transformer = GetAcceptedAgreementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAcceptedAgreementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAcceptedAgreementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAcceptedAgreementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAgreementResponse getAgreement(GetAgreementRequest request) {
        LOG.trace("Called getAgreement");
        GetAgreementRequest interceptedRequest = GetAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAgreementResponse> transformer = GetAgreementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAgreementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAgreementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAgreementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetListingResponse getListing(GetListingRequest request) {
        LOG.trace("Called getListing");
        GetListingRequest interceptedRequest = GetListingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetListingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetListingResponse> transformer = GetListingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetListingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetListingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetListingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPackageResponse getPackage(GetPackageRequest request) {
        LOG.trace("Called getPackage");
        GetPackageRequest interceptedRequest = GetPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPackageResponse> transformer = GetPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPublicationResponse getPublication(GetPublicationRequest request) {
        LOG.trace("Called getPublication");
        GetPublicationRequest interceptedRequest = GetPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicationResponse> transformer = GetPublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPublicationPackageResponse getPublicationPackage(GetPublicationPackageRequest request) {
        LOG.trace("Called getPublicationPackage");
        GetPublicationPackageRequest interceptedRequest = GetPublicationPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicationPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicationPackageResponse> transformer = GetPublicationPackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPublicationPackageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPublicationPackageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPublicationPackageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAcceptedAgreementsResponse listAcceptedAgreements(ListAcceptedAgreementsRequest request) {
        LOG.trace("Called listAcceptedAgreements");
        ListAcceptedAgreementsRequest interceptedRequest = ListAcceptedAgreementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAcceptedAgreementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAcceptedAgreementsResponse> transformer = ListAcceptedAgreementsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAcceptedAgreementsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAcceptedAgreementsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAcceptedAgreementsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAgreementsResponse listAgreements(ListAgreementsRequest request) {
        LOG.trace("Called listAgreements");
        ListAgreementsRequest interceptedRequest = ListAgreementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAgreementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAgreementsResponse> transformer = ListAgreementsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAgreementsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAgreementsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAgreementsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCategoriesResponse listCategories(ListCategoriesRequest request) {
        LOG.trace("Called listCategories");
        ListCategoriesRequest interceptedRequest = ListCategoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCategoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCategoriesResponse> transformer = ListCategoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCategoriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCategoriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCategoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListListingsResponse listListings(ListListingsRequest request) {
        LOG.trace("Called listListings");
        ListListingsRequest interceptedRequest = ListListingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListListingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListListingsResponse> transformer = ListListingsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListListingsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListListingsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListListingsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPackagesResponse listPackages(ListPackagesRequest request) {
        LOG.trace("Called listPackages");
        ListPackagesRequest interceptedRequest = ListPackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPackagesResponse> transformer = ListPackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPackagesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPackagesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPackagesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPublicationPackagesResponse listPublicationPackages(ListPublicationPackagesRequest request) {
        LOG.trace("Called listPublicationPackages");
        ListPublicationPackagesRequest interceptedRequest = ListPublicationPackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicationPackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicationPackagesResponse> transformer = ListPublicationPackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPublicationPackagesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPublicationPackagesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPublicationPackagesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPublicationsResponse listPublications(ListPublicationsRequest request) {
        LOG.trace("Called listPublications");
        ListPublicationsRequest interceptedRequest = ListPublicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicationsResponse> transformer = ListPublicationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPublicationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPublicationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPublicationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPublishersResponse listPublishers(ListPublishersRequest request) {
        LOG.trace("Called listPublishers");
        ListPublishersRequest interceptedRequest = ListPublishersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublishersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublishersResponse> transformer = ListPublishersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPublishersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPublishersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPublishersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListReportTypesResponse listReportTypes(ListReportTypesRequest request) {
        LOG.trace("Called listReportTypes");
        ListReportTypesRequest interceptedRequest = ListReportTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReportTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReportTypesResponse> transformer = ListReportTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListReportTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListReportTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListReportTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListReportsResponse listReports(ListReportsRequest request) {
        LOG.trace("Called listReports");
        ListReportsRequest interceptedRequest = ListReportsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReportsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReportsResponse> transformer = ListReportsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListReportsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListReportsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListReportsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaxesResponse listTaxes(ListTaxesRequest request) {
        LOG.trace("Called listTaxes");
        ListTaxesRequest interceptedRequest = ListTaxesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaxesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaxesResponse> transformer = ListTaxesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaxesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaxesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaxesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAcceptedAgreementResponse updateAcceptedAgreement(UpdateAcceptedAgreementRequest request) {
        LOG.trace("Called updateAcceptedAgreement");
        UpdateAcceptedAgreementRequest interceptedRequest = UpdateAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAcceptedAgreementResponse> transformer = UpdateAcceptedAgreementConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateAcceptedAgreementResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAcceptedAgreementResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAcceptedAgreementDetails(), (BmcRequest)retriedRequest);
                return (UpdateAcceptedAgreementResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePublicationResponse updatePublication(UpdatePublicationRequest request) {
        LOG.trace("Called updatePublication");
        UpdatePublicationRequest interceptedRequest = UpdatePublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePublicationResponse> transformer = UpdatePublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdatePublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePublicationDetails(), (BmcRequest)retriedRequest);
                return (UpdatePublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public MarketplaceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public MarketplacePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MarketplaceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public MarketplaceClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new MarketplaceClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

