/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.marketplace.Marketplace;
import com.oracle.bmc.marketplace.model.Publication;
import com.oracle.bmc.marketplace.requests.GetPublicationRequest;
import com.oracle.bmc.marketplace.responses.GetPublicationResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class MarketplaceWaiters {
    private final ExecutorService executorService;
    private final Marketplace client;

    public Waiter<GetPublicationRequest, GetPublicationResponse> forPublication(GetPublicationRequest request, Publication.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPublication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPublicationRequest, GetPublicationResponse> forPublication(GetPublicationRequest request, Publication.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPublication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPublicationRequest, GetPublicationResponse> forPublication(GetPublicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Publication.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPublication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPublicationRequest, GetPublicationResponse> forPublication(BmcGenericWaiter waiter, GetPublicationRequest request, Publication.LifecycleState ... targetStates) {
        final HashSet<Publication.LifecycleState> targetStatesSet = new HashSet<Publication.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetPublicationRequest, GetPublicationResponse>(){

            public GetPublicationResponse apply(GetPublicationRequest request) {
                return MarketplaceWaiters.this.client.getPublication(request);
            }
        }, (Predicate)new Predicate<GetPublicationResponse>(){

            public boolean apply(GetPublicationResponse response) {
                return targetStatesSet.contains((Object)response.getPublication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Publication.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public MarketplaceWaiters(ExecutorService executorService, Marketplace client) {
        this.executorService = executorService;
        this.client = client;
    }
}

