/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetListingRequest
extends BmcRequest<Void> {
    private String listingId;
    private String opcRequestId;
    private String compartmentId;

    @ConstructorProperties(value={"listingId", "opcRequestId", "compartmentId"})
    GetListingRequest(String listingId, String opcRequestId, String compartmentId) {
        this.listingId = listingId;
        this.opcRequestId = opcRequestId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetListingRequest, Void> {
        private String listingId;
        private String opcRequestId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetListingRequest o) {
            this.listingId(o.getListingId());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetListingRequest build() {
            GetListingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public GetListingRequest buildWithoutInvocationCallback() {
            return new GetListingRequest(this.listingId, this.opcRequestId, this.compartmentId);
        }

        public String toString() {
            return "GetListingRequest.Builder(listingId=" + this.listingId + ", opcRequestId=" + this.opcRequestId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

