/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListPublishersRequest
extends BmcRequest<Void> {
    private String publisherId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private String compartmentId;

    @ConstructorProperties(value={"publisherId", "opcRequestId", "limit", "page", "compartmentId"})
    ListPublishersRequest(String publisherId, String opcRequestId, Integer limit, String page, String compartmentId) {
        this.publisherId = publisherId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPublishersRequest, Void> {
        private String publisherId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPublishersRequest o) {
            this.publisherId(o.getPublisherId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPublishersRequest build() {
            ListPublishersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public ListPublishersRequest buildWithoutInvocationCallback() {
            return new ListPublishersRequest(this.publisherId, this.opcRequestId, this.limit, this.page, this.compartmentId);
        }

        public String toString() {
            return "ListPublishersRequest.Builder(publisherId=" + this.publisherId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

