/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListReportTypesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String page;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "page"})
    ListReportTypesRequest(String compartmentId, String opcRequestId, String page) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListReportTypesRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListReportTypesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListReportTypesRequest build() {
            ListReportTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListReportTypesRequest buildWithoutInvocationCallback() {
            return new ListReportTypesRequest(this.compartmentId, this.opcRequestId, this.page);
        }

        public String toString() {
            return "ListReportTypesRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ")";
        }
    }
}

