/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetAlarmHistoryRequest
extends BmcRequest<Void> {
    private String alarmId;
    private String opcRequestId;
    private AlarmHistorytype alarmHistorytype;
    private String page;
    private Integer limit;
    private Date timestampGreaterThanOrEqualTo;
    private Date timestampLessThan;

    @ConstructorProperties(value={"alarmId", "opcRequestId", "alarmHistorytype", "page", "limit", "timestampGreaterThanOrEqualTo", "timestampLessThan"})
    GetAlarmHistoryRequest(String alarmId, String opcRequestId, AlarmHistorytype alarmHistorytype, String page, Integer limit, Date timestampGreaterThanOrEqualTo, Date timestampLessThan) {
        this.alarmId = alarmId;
        this.opcRequestId = opcRequestId;
        this.alarmHistorytype = alarmHistorytype;
        this.page = page;
        this.limit = limit;
        this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
        this.timestampLessThan = timestampLessThan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AlarmHistorytype getAlarmHistorytype() {
        return this.alarmHistorytype;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Date getTimestampGreaterThanOrEqualTo() {
        return this.timestampGreaterThanOrEqualTo;
    }

    public Date getTimestampLessThan() {
        return this.timestampLessThan;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAlarmHistoryRequest, Void> {
        private String alarmId;
        private String opcRequestId;
        private AlarmHistorytype alarmHistorytype;
        private String page;
        private Integer limit;
        private Date timestampGreaterThanOrEqualTo;
        private Date timestampLessThan;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAlarmHistoryRequest o) {
            this.alarmId(o.getAlarmId());
            this.opcRequestId(o.getOpcRequestId());
            this.alarmHistorytype(o.getAlarmHistorytype());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.timestampGreaterThanOrEqualTo(o.getTimestampGreaterThanOrEqualTo());
            this.timestampLessThan(o.getTimestampLessThan());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAlarmHistoryRequest build() {
            GetAlarmHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder alarmHistorytype(AlarmHistorytype alarmHistorytype) {
            this.alarmHistorytype = alarmHistorytype;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder timestampGreaterThanOrEqualTo(Date timestampGreaterThanOrEqualTo) {
            this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder timestampLessThan(Date timestampLessThan) {
            this.timestampLessThan = timestampLessThan;
            return this;
        }

        public GetAlarmHistoryRequest buildWithoutInvocationCallback() {
            return new GetAlarmHistoryRequest(this.alarmId, this.opcRequestId, this.alarmHistorytype, this.page, this.limit, this.timestampGreaterThanOrEqualTo, this.timestampLessThan);
        }

        public String toString() {
            return "GetAlarmHistoryRequest.Builder(alarmId=" + this.alarmId + ", opcRequestId=" + this.opcRequestId + ", alarmHistorytype=" + (Object)((Object)this.alarmHistorytype) + ", page=" + this.page + ", limit=" + this.limit + ", timestampGreaterThanOrEqualTo=" + this.timestampGreaterThanOrEqualTo + ", timestampLessThan=" + this.timestampLessThan + ")";
        }
    }

    public static enum AlarmHistorytype {
        StateHistory("STATE_HISTORY"),
        StateTransitionHistory("STATE_TRANSITION_HISTORY");

        private final String value;
        private static Map<String, AlarmHistorytype> map;

        private AlarmHistorytype(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AlarmHistorytype create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AlarmHistorytype: " + key);
        }

        static {
            map = new HashMap<String, AlarmHistorytype>();
            for (AlarmHistorytype v : AlarmHistorytype.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

