/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.networkloadbalancer.model.BackendHealth;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBackendHealthConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetBackendHealthConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetBackendHealthRequest interceptRequest(GetBackendHealthRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetBackendHealthRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200501").path("networkLoadBalancers").path(HttpUtils.encodePathSegment((String)request.getNetworkLoadBalancerId())).path("backendSets").path(HttpUtils.encodePathSegment((String)request.getBackendSetName())).path("backends").path(HttpUtils.encodePathSegment((String)request.getBackendName())).path("health");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetBackendHealthResponse> fromResponse() {
        Function<Response, GetBackendHealthResponse> transformer = new Function<Response, GetBackendHealthResponse>(){

            public GetBackendHealthResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.networkloadbalancer.responses.GetBackendHealthResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(BackendHealth.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetBackendHealthResponse.Builder builder = GetBackendHealthResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.backendHealth((BackendHealth)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetBackendHealthResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

