/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.networkloadbalancer.model.CreateBackendDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateBackendRequest
extends BmcRequest<CreateBackendDetails> {
    private String networkLoadBalancerId;
    private CreateBackendDetails createBackendDetails;
    private String backendSetName;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    @InternalSdk
    public CreateBackendDetails getBody$() {
        return this.createBackendDetails;
    }

    @ConstructorProperties(value={"networkLoadBalancerId", "createBackendDetails", "backendSetName", "opcRequestId", "opcRetryToken", "ifMatch"})
    CreateBackendRequest(String networkLoadBalancerId, CreateBackendDetails createBackendDetails, String backendSetName, String opcRequestId, String opcRetryToken, String ifMatch) {
        this.networkLoadBalancerId = networkLoadBalancerId;
        this.createBackendDetails = createBackendDetails;
        this.backendSetName = backendSetName;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public CreateBackendDetails getCreateBackendDetails() {
        return this.createBackendDetails;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBackendRequest, CreateBackendDetails> {
        private String networkLoadBalancerId;
        private CreateBackendDetails createBackendDetails;
        private String backendSetName;
        private String opcRequestId;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBackendRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.createBackendDetails(o.getCreateBackendDetails());
            this.backendSetName(o.getBackendSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBackendRequest build() {
            CreateBackendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBackendDetails body) {
            this.createBackendDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder createBackendDetails(CreateBackendDetails createBackendDetails) {
            this.createBackendDetails = createBackendDetails;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public CreateBackendRequest buildWithoutInvocationCallback() {
            return new CreateBackendRequest(this.networkLoadBalancerId, this.createBackendDetails, this.backendSetName, this.opcRequestId, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "CreateBackendRequest.Builder(networkLoadBalancerId=" + this.networkLoadBalancerId + ", createBackendDetails=" + this.createBackendDetails + ", backendSetName=" + this.backendSetName + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

