/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteTableRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private String compartmentId;
    private Boolean isIfExists;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"tableNameOrId", "compartmentId", "isIfExists", "ifMatch", "opcRequestId"})
    DeleteTableRequest(String tableNameOrId, String compartmentId, Boolean isIfExists, String ifMatch, String opcRequestId) {
        this.tableNameOrId = tableNameOrId;
        this.compartmentId = compartmentId;
        this.isIfExists = isIfExists;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsIfExists() {
        return this.isIfExists;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTableRequest, Void> {
        private String tableNameOrId;
        private String compartmentId;
        private Boolean isIfExists;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTableRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.compartmentId(o.getCompartmentId());
            this.isIfExists(o.getIsIfExists());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTableRequest build() {
            DeleteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder isIfExists(Boolean isIfExists) {
            this.isIfExists = isIfExists;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteTableRequest buildWithoutInvocationCallback() {
            return new DeleteTableRequest(this.tableNameOrId, this.compartmentId, this.isIfExists, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteTableRequest.Builder(tableNameOrId=" + this.tableNameOrId + ", compartmentId=" + this.compartmentId + ", isIfExists=" + this.isIfExists + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

