/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetIndexRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private String indexName;
    private String compartmentId;
    private String opcRequestId;

    @ConstructorProperties(value={"tableNameOrId", "indexName", "compartmentId", "opcRequestId"})
    GetIndexRequest(String tableNameOrId, String indexName, String compartmentId, String opcRequestId) {
        this.tableNameOrId = tableNameOrId;
        this.indexName = indexName;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIndexRequest, Void> {
        private String tableNameOrId;
        private String indexName;
        private String compartmentId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIndexRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.indexName(o.getIndexName());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIndexRequest build() {
            GetIndexRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetIndexRequest buildWithoutInvocationCallback() {
            return new GetIndexRequest(this.tableNameOrId, this.indexName, this.compartmentId, this.opcRequestId);
        }

        public String toString() {
            return "GetIndexRequest.Builder(tableNameOrId=" + this.tableNameOrId + ", indexName=" + this.indexName + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

