/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetRowRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private List<String> key;
    private String compartmentId;
    private Consistency consistency;
    private Integer timeoutInMs;
    private String opcRequestId;

    @ConstructorProperties(value={"tableNameOrId", "key", "compartmentId", "consistency", "timeoutInMs", "opcRequestId"})
    GetRowRequest(String tableNameOrId, List<String> key, String compartmentId, Consistency consistency, Integer timeoutInMs, String opcRequestId) {
        this.tableNameOrId = tableNameOrId;
        this.key = key;
        this.compartmentId = compartmentId;
        this.consistency = consistency;
        this.timeoutInMs = timeoutInMs;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public List<String> getKey() {
        return this.key;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public Integer getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRowRequest, Void> {
        private String tableNameOrId;
        private List<String> key;
        private String compartmentId;
        private Consistency consistency;
        private Integer timeoutInMs;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRowRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.key(o.getKey());
            this.compartmentId(o.getCompartmentId());
            this.consistency(o.getConsistency());
            this.timeoutInMs(o.getTimeoutInMs());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRowRequest build() {
            GetRowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder key(List<String> key) {
            this.key = key;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder consistency(Consistency consistency) {
            this.consistency = consistency;
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRowRequest buildWithoutInvocationCallback() {
            return new GetRowRequest(this.tableNameOrId, this.key, this.compartmentId, this.consistency, this.timeoutInMs, this.opcRequestId);
        }

        public String toString() {
            return "GetRowRequest.Builder(tableNameOrId=" + this.tableNameOrId + ", key=" + this.key + ", compartmentId=" + this.compartmentId + ", consistency=" + (Object)((Object)this.consistency) + ", timeoutInMs=" + this.timeoutInMs + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum Consistency {
        Eventual("EVENTUAL"),
        Absolute("ABSOLUTE");

        private final String value;
        private static Map<String, Consistency> map;

        private Consistency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Consistency create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Consistency: " + key);
        }

        static {
            map = new HashMap<String, Consistency>();
            for (Consistency v : Consistency.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

