/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.nosql.model.QueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class QueryRequest
extends BmcRequest<QueryDetails> {
    private QueryDetails queryDetails;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @InternalSdk
    public QueryDetails getBody$() {
        return this.queryDetails;
    }

    @ConstructorProperties(value={"queryDetails", "limit", "page", "opcRequestId"})
    QueryRequest(QueryDetails queryDetails, Integer limit, String page, String opcRequestId) {
        this.queryDetails = queryDetails;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public QueryDetails getQueryDetails() {
        return this.queryDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryRequest, QueryDetails> {
        private QueryDetails queryDetails;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryRequest o) {
            this.queryDetails(o.getQueryDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryRequest build() {
            QueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryDetails body) {
            this.queryDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder queryDetails(QueryDetails queryDetails) {
            this.queryDetails = queryDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public QueryRequest buildWithoutInvocationCallback() {
            return new QueryRequest(this.queryDetails, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "QueryRequest.Builder(queryDetails=" + this.queryDetails + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

