/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class SummarizeStatementRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String statement;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "statement", "opcRequestId"})
    SummarizeStatementRequest(String compartmentId, String statement, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.statement = statement;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeStatementRequest, Void> {
        private String compartmentId;
        private String statement;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeStatementRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.statement(o.getStatement());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeStatementRequest build() {
            SummarizeStatementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SummarizeStatementRequest buildWithoutInvocationCallback() {
            return new SummarizeStatementRequest(this.compartmentId, this.statement, this.opcRequestId);
        }

        public String toString() {
            return "SummarizeStatementRequest.Builder(compartmentId=" + this.compartmentId + ", statement=" + this.statement + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

