/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.transfer.DownloadConfiguration;
import com.oracle.bmc.objectstorage.transfer.internal.download.DownloadExecution;
import com.oracle.bmc.objectstorage.transfer.internal.download.MultithreadStream;
import com.oracle.bmc.objectstorage.transfer.internal.download.RetryingStream;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadManager {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadManager.class);
    private static final RetryConfiguration NO_RETRIES_IN_CLIENT = RetryConfiguration.builder().terminationStrategy((TerminationStrategy)new MaxAttemptsTerminationStrategy(1)).build();
    private final ObjectStorage objectStorage;
    private final DownloadConfiguration config;

    public GetObjectResponse getObject(GetObjectRequest request) {
        InputStream stream;
        GetObjectResponse response;
        request = GetObjectRequest.builder().copy(request).retryConfiguration(NO_RETRIES_IN_CLIENT).build();
        DownloadExecution execution = DownloadExecution.fromConfig(this.config);
        while (true) {
            try {
                response = this.objectStorage.getObject(request);
            }
            catch (Throwable t) {
                if (execution.shouldRetryOn(t)) continue;
                throw t;
            }
            break;
        }
        if (response.isNotModified()) {
            return response;
        }
        String etag = response.getETag();
        GetObjectRequest requestWithEtag = GetObjectRequest.builder().copy(request).ifMatch(etag).build();
        RetryingStream retryingStream = new RetryingStream(this.objectStorage, requestWithEtag, response, execution);
        if (this.config.getParallelDownloads() > 0 && response.getContentLength() > this.config.getMultipartDownloadThresholdInBytes() && response.getContentLength() > 0x400000L) {
            int totalWorkers = this.config.getParallelDownloads() + 1;
            assert (totalWorkers >= 2);
            int partSize = response.getContentLength() >= (long)totalWorkers * (long)this.config.getPartSizeInBytes() ? this.config.getPartSizeInBytes() : Math.max(Math.toIntExact(response.getContentLength() / (long)totalWorkers), 0x400000);
            assert (partSize <= this.config.getPartSizeInBytes());
            assert (partSize >= 0x400000);
            LOG.trace("partSizeInBytes = {}", (Object)partSize);
            int numParts = Math.toIntExact((response.getContentLength() + (long)partSize - 1L) / (long)partSize);
            assert (numParts >= 2);
            int numThreads = Math.min(this.config.getParallelDownloads(), numParts - 1);
            assert (numThreads > 0);
            stream = new MultithreadStream(this, requestWithEtag, response.getContentLength(), retryingStream, this.config.getParallelDownloads(), this.config.getExecutorService(), partSize);
        } else {
            stream = retryingStream;
        }
        GetObjectResponse retryingResponse = GetObjectResponse.builder().copy(response).inputStream(stream).build();
        return retryingResponse;
    }

    public GetObjectResponse downloadObjectToFile(GetObjectRequest request, File target) throws IOException {
        GetObjectResponse response = this.getObject(request);
        try (InputStream stream = response.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(target);){
            int bytesRead;
            byte[] buf = new byte[8192];
            while ((bytesRead = stream.read(buf)) > 0) {
                ((OutputStream)outputStream).write(buf, 0, bytesRead);
            }
        }
        return response;
    }

    public GetObjectResponse getObject_singleThreaded(GetObjectRequest request) {
        GetObjectResponse response;
        DownloadExecution execution = DownloadExecution.fromConfig(this.config);
        while (true) {
            try {
                response = this.objectStorage.getObject(request);
            }
            catch (Throwable t) {
                if (execution.shouldRetryOn(t)) continue;
                throw t;
            }
            break;
        }
        String etag = response.getETag();
        GetObjectRequest requestWithEtag = GetObjectRequest.builder().copy(request).ifMatch(etag).build();
        RetryingStream retryingStream = new RetryingStream(this.objectStorage, requestWithEtag, response, execution);
        GetObjectResponse retryingResponse = GetObjectResponse.builder().copy(response).inputStream((InputStream)retryingStream).build();
        return retryingResponse;
    }

    @ConstructorProperties(value={"objectStorage", "config"})
    public DownloadManager(ObjectStorage objectStorage, DownloadConfiguration config) {
        this.objectStorage = objectStorage;
        this.config = config;
    }
}

