/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal.download;

import com.oracle.bmc.model.Range;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.transfer.internal.download.DownloadExecution;
import com.oracle.bmc.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingStream.class);
    private final ObjectStorage objectStorage;
    private final DownloadExecution execution;
    private GetObjectRequest request;
    private GetObjectResponse response;
    private long bytesInResponse;
    private long bytesReadFromResponse;
    private boolean isClosed;

    public RetryingStream(ObjectStorage objectStorage, GetObjectRequest request, GetObjectResponse response, DownloadExecution execution) {
        this.objectStorage = objectStorage;
        this.request = request;
        this.response = response;
        this.bytesReadFromResponse = 0L;
        this.bytesInResponse = response.getContentLength();
        this.execution = execution;
        this.isClosed = false;
    }

    @Override
    public synchronized void close() throws IOException {
        StreamUtils.closeQuietly((InputStream)this.response.getInputStream());
        this.response = null;
        this.request = null;
        this.isClosed = true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.bytesInResponse == this.bytesReadFromResponse) {
            return -1;
        }
        this.throwIfClosed();
        while (true) {
            try {
                int value = this.response.getInputStream().read();
                if (value >= 0) {
                    ++this.bytesReadFromResponse;
                }
                return value;
            }
            catch (Throwable t) {
                if (this.execution.shouldRetryOn(t)) {
                    LOG.info("Refreshing request on retry", t);
                    this.refresh();
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.bytesInResponse == this.bytesReadFromResponse) {
            return -1;
        }
        this.throwIfClosed();
        while (true) {
            try {
                int bytesRead = this.response.getInputStream().read(b, off, len);
                LOG.trace("Read {} bytes", (Object)bytesRead);
                if (bytesRead > 0) {
                    this.bytesReadFromResponse += (long)bytesRead;
                }
                return bytesRead;
            }
            catch (Throwable t) {
                if (this.execution.shouldRetryOn(t)) {
                    LOG.info("Refreshing request on retry", t);
                    this.refresh();
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    private void throwIfClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream has been closed");
        }
    }

    private void refresh() {
        StreamUtils.closeQuietly((InputStream)this.response.getInputStream());
        this.refreshRequest();
        while (true) {
            try {
                this.response = this.objectStorage.getObject(this.request);
            }
            catch (Throwable t) {
                if (this.execution.shouldRetryOn(t)) continue;
                throw t;
            }
            break;
        }
        this.bytesInResponse = this.response.getContentLength();
        this.bytesReadFromResponse = 0L;
    }

    private void refreshRequest() {
        GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder();
        requestBuilder.copy(this.request);
        Range currentRange = this.request.getRange();
        Range newRange = null == currentRange ? new Range(Long.valueOf(this.bytesReadFromResponse), null) : (currentRange.getStartByte() == null ? new Range(Long.valueOf(this.bytesReadFromResponse), currentRange.getEndByte()) : new Range(Long.valueOf(currentRange.getStartByte() + this.bytesReadFromResponse), currentRange.getEndByte()));
        LOG.info("Current range was {}. New range is = {}", (Object)currentRange, (Object)newRange);
        requestBuilder.range(newRange);
        this.request = requestBuilder.build();
    }
}

