/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.ocvp.EsxiHost;
import com.oracle.bmc.ocvp.model.EsxiHostSummary;
import com.oracle.bmc.ocvp.requests.ListEsxiHostsRequest;
import com.oracle.bmc.ocvp.responses.ListEsxiHostsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class EsxiHostPaginators {
    private final EsxiHost client;

    public Iterable<ListEsxiHostsResponse> listEsxiHostsResponseIterator(final ListEsxiHostsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEsxiHostsRequest.Builder>(){

            public ListEsxiHostsRequest.Builder get() {
                return ListEsxiHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEsxiHostsResponse, String>(){

            public String apply(ListEsxiHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEsxiHostsRequest.Builder>, ListEsxiHostsRequest>(){

            public ListEsxiHostsRequest apply(RequestBuilderAndToken<ListEsxiHostsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListEsxiHostsRequest, ListEsxiHostsResponse>(){

            public ListEsxiHostsResponse apply(ListEsxiHostsRequest request) {
                return EsxiHostPaginators.this.client.listEsxiHosts(request);
            }
        });
    }

    public Iterable<EsxiHostSummary> listEsxiHostsRecordIterator(final ListEsxiHostsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEsxiHostsRequest.Builder>(){

            public ListEsxiHostsRequest.Builder get() {
                return ListEsxiHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEsxiHostsResponse, String>(){

            public String apply(ListEsxiHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEsxiHostsRequest.Builder>, ListEsxiHostsRequest>(){

            public ListEsxiHostsRequest apply(RequestBuilderAndToken<ListEsxiHostsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListEsxiHostsRequest, ListEsxiHostsResponse>(){

            public ListEsxiHostsResponse apply(ListEsxiHostsRequest request) {
                return EsxiHostPaginators.this.client.listEsxiHosts(request);
            }
        }, (Function)new Function<ListEsxiHostsResponse, List<EsxiHostSummary>>(){

            public List<EsxiHostSummary> apply(ListEsxiHostsResponse response) {
                return response.getEsxiHostCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public EsxiHostPaginators(EsxiHost client) {
        this.client = client;
    }
}

