/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.ocvp.Sddc;
import com.oracle.bmc.ocvp.model.LifecycleStates;
import com.oracle.bmc.ocvp.requests.GetSddcRequest;
import com.oracle.bmc.ocvp.responses.GetSddcResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class SddcWaiters {
    private final ExecutorService executorService;
    private final Sddc client;

    public Waiter<GetSddcRequest, GetSddcResponse> forSddc(GetSddcRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSddc(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSddcRequest, GetSddcResponse> forSddc(GetSddcRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSddc(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSddcRequest, GetSddcResponse> forSddc(GetSddcRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSddc(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSddcRequest, GetSddcResponse> forSddc(BmcGenericWaiter waiter, GetSddcRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetSddcRequest, GetSddcResponse>(){

            public GetSddcResponse apply(GetSddcRequest request) {
                return SddcWaiters.this.client.getSddc(request);
            }
        }, (Predicate)new Predicate<GetSddcResponse>(){

            public boolean apply(GetSddcResponse response) {
                return targetStatesSet.contains((Object)response.getSddc().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public SddcWaiters(ExecutorService executorService, Sddc client) {
        this.executorService = executorService;
        this.client = client;
    }
}

