/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.oda.Oda;
import com.oracle.bmc.oda.model.OdaInstance;
import com.oracle.bmc.oda.requests.GetOdaInstanceRequest;
import com.oracle.bmc.oda.requests.GetWorkRequestRequest;
import com.oracle.bmc.oda.responses.GetOdaInstanceResponse;
import com.oracle.bmc.oda.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class OdaWaiters {
    private final ExecutorService executorService;
    private final Oda client;

    public Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(GetOdaInstanceRequest request, OdaInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOdaInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(GetOdaInstanceRequest request, OdaInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOdaInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(GetOdaInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OdaInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOdaInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(BmcGenericWaiter waiter, GetOdaInstanceRequest request, OdaInstance.LifecycleState ... targetStates) {
        final HashSet<OdaInstance.LifecycleState> targetStatesSet = new HashSet<OdaInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetOdaInstanceRequest, GetOdaInstanceResponse>(){

            public GetOdaInstanceResponse apply(GetOdaInstanceRequest request) {
                return OdaWaiters.this.client.getOdaInstance(request);
            }
        }, (Predicate)new Predicate<GetOdaInstanceResponse>(){

            public boolean apply(GetOdaInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getOdaInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OdaInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OdaWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public OdaWaiters(ExecutorService executorService, Oda client) {
        this.executorService = executorService;
        this.client = client;
    }
}

