/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.ons.model.NotificationTopicSummary;
import com.oracle.bmc.ons.requests.ListTopicsRequest;
import com.oracle.bmc.ons.responses.ListTopicsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTopicsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTopicsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTopicsRequest interceptRequest(ListTopicsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTopicsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("topics");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getId() != null) {
            target = target.queryParam("id", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getId())});
        }
        if (request.getName() != null) {
            target = target.queryParam("name", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getName())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListTopicsResponse> fromResponse() {
        Function<Response, ListTopicsResponse> transformer = new Function<Response, ListTopicsResponse>(){

            public ListTopicsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcPreviousPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.ons.responses.ListTopicsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<NotificationTopicSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListTopicsResponse.Builder builder = ListTopicsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPreviousPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-previous-page")).isPresent()) {
                    builder.opcPreviousPage((String)HeaderUtils.toValue((String)"opc-previous-page", (String)((String)((List)opcPreviousPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListTopicsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

