/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.optimizer.OptimizerAsync;
import com.oracle.bmc.optimizer.internal.http.BulkApplyRecommendationsConverter;
import com.oracle.bmc.optimizer.internal.http.CreateProfileConverter;
import com.oracle.bmc.optimizer.internal.http.DeleteProfileConverter;
import com.oracle.bmc.optimizer.internal.http.GetCategoryConverter;
import com.oracle.bmc.optimizer.internal.http.GetEnrollmentStatusConverter;
import com.oracle.bmc.optimizer.internal.http.GetProfileConverter;
import com.oracle.bmc.optimizer.internal.http.GetRecommendationConverter;
import com.oracle.bmc.optimizer.internal.http.GetResourceActionConverter;
import com.oracle.bmc.optimizer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.optimizer.internal.http.ListCategoriesConverter;
import com.oracle.bmc.optimizer.internal.http.ListEnrollmentStatusesConverter;
import com.oracle.bmc.optimizer.internal.http.ListHistoriesConverter;
import com.oracle.bmc.optimizer.internal.http.ListProfilesConverter;
import com.oracle.bmc.optimizer.internal.http.ListRecommendationStrategiesConverter;
import com.oracle.bmc.optimizer.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.optimizer.internal.http.ListResourceActionsConverter;
import com.oracle.bmc.optimizer.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.optimizer.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.optimizer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateEnrollmentStatusConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateProfileConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateRecommendationConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateResourceActionConverter;
import com.oracle.bmc.optimizer.requests.BulkApplyRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.CreateProfileRequest;
import com.oracle.bmc.optimizer.requests.DeleteProfileRequest;
import com.oracle.bmc.optimizer.requests.GetCategoryRequest;
import com.oracle.bmc.optimizer.requests.GetEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.GetProfileRequest;
import com.oracle.bmc.optimizer.requests.GetRecommendationRequest;
import com.oracle.bmc.optimizer.requests.GetResourceActionRequest;
import com.oracle.bmc.optimizer.requests.GetWorkRequestRequest;
import com.oracle.bmc.optimizer.requests.ListCategoriesRequest;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.requests.ListHistoriesRequest;
import com.oracle.bmc.optimizer.requests.ListProfilesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationStrategiesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.optimizer.requests.UpdateEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.UpdateProfileRequest;
import com.oracle.bmc.optimizer.requests.UpdateRecommendationRequest;
import com.oracle.bmc.optimizer.requests.UpdateResourceActionRequest;
import com.oracle.bmc.optimizer.responses.BulkApplyRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.CreateProfileResponse;
import com.oracle.bmc.optimizer.responses.DeleteProfileResponse;
import com.oracle.bmc.optimizer.responses.GetCategoryResponse;
import com.oracle.bmc.optimizer.responses.GetEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.GetProfileResponse;
import com.oracle.bmc.optimizer.responses.GetRecommendationResponse;
import com.oracle.bmc.optimizer.responses.GetResourceActionResponse;
import com.oracle.bmc.optimizer.responses.GetWorkRequestResponse;
import com.oracle.bmc.optimizer.responses.ListCategoriesResponse;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.optimizer.responses.ListHistoriesResponse;
import com.oracle.bmc.optimizer.responses.ListProfilesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationStrategiesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.optimizer.responses.UpdateEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.UpdateProfileResponse;
import com.oracle.bmc.optimizer.responses.UpdateRecommendationResponse;
import com.oracle.bmc.optimizer.responses.UpdateResourceActionResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerAsyncClient
implements OptimizerAsync {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizerAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPTIMIZER").serviceEndpointPrefix("").serviceEndpointTemplate("https://optimizer.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public OptimizerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OptimizerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OptimizerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OptimizerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OptimizerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OptimizerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OptimizerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public OptimizerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<BulkApplyRecommendationsResponse> bulkApplyRecommendations(BulkApplyRecommendationsRequest request, AsyncHandler<BulkApplyRecommendationsRequest, BulkApplyRecommendationsResponse> handler) {
        LOG.trace("Called async bulkApplyRecommendations");
        BulkApplyRecommendationsRequest interceptedRequest = BulkApplyRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkApplyRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkApplyRecommendationsResponse> transformer = BulkApplyRecommendationsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BulkApplyRecommendationsRequest, BulkApplyRecommendationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BulkApplyRecommendationsRequest, BulkApplyRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateProfileResponse> createProfile(CreateProfileRequest request, AsyncHandler<CreateProfileRequest, CreateProfileResponse> handler) {
        LOG.trace("Called async createProfile");
        CreateProfileRequest interceptedRequest = CreateProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateProfileResponse> transformer = CreateProfileConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateProfileRequest, CreateProfileResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateProfileRequest, CreateProfileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteProfileResponse> deleteProfile(DeleteProfileRequest request, AsyncHandler<DeleteProfileRequest, DeleteProfileResponse> handler) {
        LOG.trace("Called async deleteProfile");
        DeleteProfileRequest interceptedRequest = DeleteProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteProfileResponse> transformer = DeleteProfileConverter.fromResponse();
        AsyncHandler<DeleteProfileRequest, DeleteProfileResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteProfileRequest, DeleteProfileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCategoryResponse> getCategory(GetCategoryRequest request, AsyncHandler<GetCategoryRequest, GetCategoryResponse> handler) {
        LOG.trace("Called async getCategory");
        GetCategoryRequest interceptedRequest = GetCategoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCategoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCategoryResponse> transformer = GetCategoryConverter.fromResponse();
        AsyncHandler<GetCategoryRequest, GetCategoryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCategoryRequest, GetCategoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEnrollmentStatusResponse> getEnrollmentStatus(GetEnrollmentStatusRequest request, AsyncHandler<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> handler) {
        LOG.trace("Called async getEnrollmentStatus");
        GetEnrollmentStatusRequest interceptedRequest = GetEnrollmentStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEnrollmentStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetEnrollmentStatusResponse> transformer = GetEnrollmentStatusConverter.fromResponse();
        AsyncHandler<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProfileResponse> getProfile(GetProfileRequest request, AsyncHandler<GetProfileRequest, GetProfileResponse> handler) {
        LOG.trace("Called async getProfile");
        GetProfileRequest interceptedRequest = GetProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProfileResponse> transformer = GetProfileConverter.fromResponse();
        AsyncHandler<GetProfileRequest, GetProfileResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProfileRequest, GetProfileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRecommendationResponse> getRecommendation(GetRecommendationRequest request, AsyncHandler<GetRecommendationRequest, GetRecommendationResponse> handler) {
        LOG.trace("Called async getRecommendation");
        GetRecommendationRequest interceptedRequest = GetRecommendationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRecommendationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRecommendationResponse> transformer = GetRecommendationConverter.fromResponse();
        AsyncHandler<GetRecommendationRequest, GetRecommendationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRecommendationRequest, GetRecommendationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResourceActionResponse> getResourceAction(GetResourceActionRequest request, AsyncHandler<GetResourceActionRequest, GetResourceActionResponse> handler) {
        LOG.trace("Called async getResourceAction");
        GetResourceActionRequest interceptedRequest = GetResourceActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResourceActionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResourceActionResponse> transformer = GetResourceActionConverter.fromResponse();
        AsyncHandler<GetResourceActionRequest, GetResourceActionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResourceActionRequest, GetResourceActionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCategoriesResponse> listCategories(ListCategoriesRequest request, AsyncHandler<ListCategoriesRequest, ListCategoriesResponse> handler) {
        LOG.trace("Called async listCategories");
        ListCategoriesRequest interceptedRequest = ListCategoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCategoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCategoriesResponse> transformer = ListCategoriesConverter.fromResponse();
        AsyncHandler<ListCategoriesRequest, ListCategoriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCategoriesRequest, ListCategoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEnrollmentStatusesResponse> listEnrollmentStatuses(ListEnrollmentStatusesRequest request, AsyncHandler<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse> handler) {
        LOG.trace("Called async listEnrollmentStatuses");
        ListEnrollmentStatusesRequest interceptedRequest = ListEnrollmentStatusesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEnrollmentStatusesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEnrollmentStatusesResponse> transformer = ListEnrollmentStatusesConverter.fromResponse();
        AsyncHandler<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListHistoriesResponse> listHistories(ListHistoriesRequest request, AsyncHandler<ListHistoriesRequest, ListHistoriesResponse> handler) {
        LOG.trace("Called async listHistories");
        ListHistoriesRequest interceptedRequest = ListHistoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHistoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHistoriesResponse> transformer = ListHistoriesConverter.fromResponse();
        AsyncHandler<ListHistoriesRequest, ListHistoriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListHistoriesRequest, ListHistoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProfilesResponse> listProfiles(ListProfilesRequest request, AsyncHandler<ListProfilesRequest, ListProfilesResponse> handler) {
        LOG.trace("Called async listProfiles");
        ListProfilesRequest interceptedRequest = ListProfilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProfilesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProfilesResponse> transformer = ListProfilesConverter.fromResponse();
        AsyncHandler<ListProfilesRequest, ListProfilesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProfilesRequest, ListProfilesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRecommendationStrategiesResponse> listRecommendationStrategies(ListRecommendationStrategiesRequest request, AsyncHandler<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse> handler) {
        LOG.trace("Called async listRecommendationStrategies");
        ListRecommendationStrategiesRequest interceptedRequest = ListRecommendationStrategiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationStrategiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecommendationStrategiesResponse> transformer = ListRecommendationStrategiesConverter.fromResponse();
        AsyncHandler<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRecommendationsResponse> listRecommendations(ListRecommendationsRequest request, AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handler) {
        LOG.trace("Called async listRecommendations");
        ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRecommendationsRequest, ListRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResourceActionsResponse> listResourceActions(ListResourceActionsRequest request, AsyncHandler<ListResourceActionsRequest, ListResourceActionsResponse> handler) {
        LOG.trace("Called async listResourceActions");
        ListResourceActionsRequest interceptedRequest = ListResourceActionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResourceActionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResourceActionsResponse> transformer = ListResourceActionsConverter.fromResponse();
        AsyncHandler<ListResourceActionsRequest, ListResourceActionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResourceActionsRequest, ListResourceActionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateEnrollmentStatusResponse> updateEnrollmentStatus(UpdateEnrollmentStatusRequest request, AsyncHandler<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResponse> handler) {
        LOG.trace("Called async updateEnrollmentStatus");
        UpdateEnrollmentStatusRequest interceptedRequest = UpdateEnrollmentStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEnrollmentStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateEnrollmentStatusResponse> transformer = UpdateEnrollmentStatusConverter.fromResponse();
        AsyncHandler<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProfileResponse> updateProfile(UpdateProfileRequest request, AsyncHandler<UpdateProfileRequest, UpdateProfileResponse> handler) {
        LOG.trace("Called async updateProfile");
        UpdateProfileRequest interceptedRequest = UpdateProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProfileResponse> transformer = UpdateProfileConverter.fromResponse();
        AsyncHandler<UpdateProfileRequest, UpdateProfileResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProfileRequest, UpdateProfileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRecommendationResponse> updateRecommendation(UpdateRecommendationRequest request, AsyncHandler<UpdateRecommendationRequest, UpdateRecommendationResponse> handler) {
        LOG.trace("Called async updateRecommendation");
        UpdateRecommendationRequest interceptedRequest = UpdateRecommendationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRecommendationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRecommendationResponse> transformer = UpdateRecommendationConverter.fromResponse();
        AsyncHandler<UpdateRecommendationRequest, UpdateRecommendationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRecommendationRequest, UpdateRecommendationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateResourceActionResponse> updateResourceAction(UpdateResourceActionRequest request, AsyncHandler<UpdateResourceActionRequest, UpdateResourceActionResponse> handler) {
        LOG.trace("Called async updateResourceAction");
        UpdateResourceActionRequest interceptedRequest = UpdateResourceActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResourceActionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResourceActionResponse> transformer = UpdateResourceActionConverter.fromResponse();
        AsyncHandler<UpdateResourceActionRequest, UpdateResourceActionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateResourceActionRequest, UpdateResourceActionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OptimizerAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OptimizerAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OptimizerAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

