/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.optimizer.model.BulkApplyRecommendationsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class BulkApplyRecommendationsRequest
extends BmcRequest<BulkApplyRecommendationsDetails> {
    private String recommendationId;
    private BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public BulkApplyRecommendationsDetails getBody$() {
        return this.bulkApplyRecommendationsDetails;
    }

    @ConstructorProperties(value={"recommendationId", "bulkApplyRecommendationsDetails", "opcRequestId", "opcRetryToken"})
    BulkApplyRecommendationsRequest(String recommendationId, BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails, String opcRequestId, String opcRetryToken) {
        this.recommendationId = recommendationId;
        this.bulkApplyRecommendationsDetails = bulkApplyRecommendationsDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public BulkApplyRecommendationsDetails getBulkApplyRecommendationsDetails() {
        return this.bulkApplyRecommendationsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkApplyRecommendationsRequest, BulkApplyRecommendationsDetails> {
        private String recommendationId;
        private BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkApplyRecommendationsRequest o) {
            this.recommendationId(o.getRecommendationId());
            this.bulkApplyRecommendationsDetails(o.getBulkApplyRecommendationsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkApplyRecommendationsRequest build() {
            BulkApplyRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkApplyRecommendationsDetails body) {
            this.bulkApplyRecommendationsDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public Builder bulkApplyRecommendationsDetails(BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails) {
            this.bulkApplyRecommendationsDetails = bulkApplyRecommendationsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public BulkApplyRecommendationsRequest buildWithoutInvocationCallback() {
            return new BulkApplyRecommendationsRequest(this.recommendationId, this.bulkApplyRecommendationsDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "BulkApplyRecommendationsRequest.Builder(recommendationId=" + this.recommendationId + ", bulkApplyRecommendationsDetails=" + this.bulkApplyRecommendationsDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

