/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetEnrollmentStatusRequest
extends BmcRequest<Void> {
    private String enrollmentStatusId;
    private String opcRequestId;

    @ConstructorProperties(value={"enrollmentStatusId", "opcRequestId"})
    GetEnrollmentStatusRequest(String enrollmentStatusId, String opcRequestId) {
        this.enrollmentStatusId = enrollmentStatusId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEnrollmentStatusId() {
        return this.enrollmentStatusId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEnrollmentStatusRequest, Void> {
        private String enrollmentStatusId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEnrollmentStatusRequest o) {
            this.enrollmentStatusId(o.getEnrollmentStatusId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEnrollmentStatusRequest build() {
            GetEnrollmentStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder enrollmentStatusId(String enrollmentStatusId) {
            this.enrollmentStatusId = enrollmentStatusId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetEnrollmentStatusRequest buildWithoutInvocationCallback() {
            return new GetEnrollmentStatusRequest(this.enrollmentStatusId, this.opcRequestId);
        }

        public String toString() {
            return "GetEnrollmentStatusRequest.Builder(enrollmentStatusId=" + this.enrollmentStatusId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

