/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetResourceActionRequest
extends BmcRequest<Void> {
    private String resourceActionId;
    private String opcRequestId;

    @ConstructorProperties(value={"resourceActionId", "opcRequestId"})
    GetResourceActionRequest(String resourceActionId, String opcRequestId) {
        this.resourceActionId = resourceActionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResourceActionId() {
        return this.resourceActionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResourceActionRequest, Void> {
        private String resourceActionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceActionRequest o) {
            this.resourceActionId(o.getResourceActionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceActionRequest build() {
            GetResourceActionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder resourceActionId(String resourceActionId) {
            this.resourceActionId = resourceActionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetResourceActionRequest buildWithoutInvocationCallback() {
            return new GetResourceActionRequest(this.resourceActionId, this.opcRequestId);
        }

        public String toString() {
            return "GetResourceActionRequest.Builder(resourceActionId=" + this.resourceActionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

