/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.optimizer.model.LifecycleState;
import com.oracle.bmc.optimizer.model.OptimizerEnrollmentStatus;
import com.oracle.bmc.optimizer.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListEnrollmentStatusesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private LifecycleState lifecycleState;
    private OptimizerEnrollmentStatus status;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "sortOrder", "sortBy", "lifecycleState", "status", "opcRequestId"})
    ListEnrollmentStatusesRequest(String compartmentId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, LifecycleState lifecycleState, OptimizerEnrollmentStatus status, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.lifecycleState = lifecycleState;
        this.status = status;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public OptimizerEnrollmentStatus getStatus() {
        return this.status;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListEnrollmentStatusesRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private LifecycleState lifecycleState;
        private OptimizerEnrollmentStatus status;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListEnrollmentStatusesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.status(o.getStatus());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListEnrollmentStatusesRequest build() {
            ListEnrollmentStatusesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder status(OptimizerEnrollmentStatus status) {
            this.status = status;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListEnrollmentStatusesRequest buildWithoutInvocationCallback() {
            return new ListEnrollmentStatusesRequest(this.compartmentId, this.limit, this.page, this.sortOrder, this.sortBy, this.lifecycleState, this.status, this.opcRequestId);
        }

        public String toString() {
            return "ListEnrollmentStatusesRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", status=" + (Object)((Object)this.status) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Name("NAME"),
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

