/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.rover.RoverCluster;
import com.oracle.bmc.rover.RoverClusterPaginators;
import com.oracle.bmc.rover.RoverClusterWaiters;
import com.oracle.bmc.rover.internal.http.ChangeRoverClusterCompartmentConverter;
import com.oracle.bmc.rover.internal.http.CreateRoverClusterConverter;
import com.oracle.bmc.rover.internal.http.DeleteRoverClusterConverter;
import com.oracle.bmc.rover.internal.http.GetRoverClusterCertificateConverter;
import com.oracle.bmc.rover.internal.http.GetRoverClusterConverter;
import com.oracle.bmc.rover.internal.http.ListRoverClustersConverter;
import com.oracle.bmc.rover.internal.http.UpdateRoverClusterConverter;
import com.oracle.bmc.rover.requests.ChangeRoverClusterCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverClusterRequest;
import com.oracle.bmc.rover.requests.DeleteRoverClusterRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterRequest;
import com.oracle.bmc.rover.requests.ListRoverClustersRequest;
import com.oracle.bmc.rover.requests.UpdateRoverClusterRequest;
import com.oracle.bmc.rover.responses.ChangeRoverClusterCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverClusterResponse;
import com.oracle.bmc.rover.responses.DeleteRoverClusterResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterResponse;
import com.oracle.bmc.rover.responses.ListRoverClustersResponse;
import com.oracle.bmc.rover.responses.UpdateRoverClusterResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverClusterClient
implements RoverCluster {
    private static final Logger LOG = LoggerFactory.getLogger(RoverClusterClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final RoverClusterWaiters waiters;
    private final RoverClusterPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public RoverClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RoverClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RoverClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected RoverClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RoverCluster-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RoverClusterWaiters(executorService, this);
        this.paginators = new RoverClusterPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeRoverClusterCompartmentResponse changeRoverClusterCompartment(ChangeRoverClusterCompartmentRequest request) {
        LOG.trace("Called changeRoverClusterCompartment");
        ChangeRoverClusterCompartmentRequest interceptedRequest = ChangeRoverClusterCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRoverClusterCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRoverClusterCompartmentResponse> transformer = ChangeRoverClusterCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeRoverClusterCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeRoverClusterCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeRoverClusterCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeRoverClusterCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRoverClusterResponse createRoverCluster(CreateRoverClusterRequest request) {
        LOG.trace("Called createRoverCluster");
        CreateRoverClusterRequest interceptedRequest = CreateRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoverClusterResponse> transformer = CreateRoverClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateRoverClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRoverClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRoverClusterDetails(), (BmcRequest)retriedRequest);
                return (CreateRoverClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRoverClusterResponse deleteRoverCluster(DeleteRoverClusterRequest request) {
        LOG.trace("Called deleteRoverCluster");
        DeleteRoverClusterRequest interceptedRequest = DeleteRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoverClusterResponse> transformer = DeleteRoverClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRoverClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRoverClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRoverClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverClusterResponse getRoverCluster(GetRoverClusterRequest request) {
        LOG.trace("Called getRoverCluster");
        GetRoverClusterRequest interceptedRequest = GetRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverClusterResponse> transformer = GetRoverClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoverClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverClusterCertificateResponse getRoverClusterCertificate(GetRoverClusterCertificateRequest request) {
        LOG.trace("Called getRoverClusterCertificate");
        GetRoverClusterCertificateRequest interceptedRequest = GetRoverClusterCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverClusterCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverClusterCertificateResponse> transformer = GetRoverClusterCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoverClusterCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverClusterCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverClusterCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRoverClustersResponse listRoverClusters(ListRoverClustersRequest request) {
        LOG.trace("Called listRoverClusters");
        ListRoverClustersRequest interceptedRequest = ListRoverClustersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoverClustersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoverClustersResponse> transformer = ListRoverClustersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRoverClustersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRoverClustersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRoverClustersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRoverClusterResponse updateRoverCluster(UpdateRoverClusterRequest request) {
        LOG.trace("Called updateRoverCluster");
        UpdateRoverClusterRequest interceptedRequest = UpdateRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoverClusterResponse> transformer = UpdateRoverClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRoverClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRoverClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRoverClusterDetails(), (BmcRequest)retriedRequest);
                return (UpdateRoverClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RoverClusterWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RoverClusterPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverClusterClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RoverClusterClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RoverClusterClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

