/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.rover.RoverEntitlement;
import com.oracle.bmc.rover.model.RoverEntitlement;
import com.oracle.bmc.rover.requests.GetRoverEntitlementRequest;
import com.oracle.bmc.rover.responses.GetRoverEntitlementResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class RoverEntitlementWaiters {
    private final ExecutorService executorService;
    private final RoverEntitlement client;

    public Waiter<GetRoverEntitlementRequest, GetRoverEntitlementResponse> forRoverEntitlement(GetRoverEntitlementRequest request, RoverEntitlement.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRoverEntitlement(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRoverEntitlementRequest, GetRoverEntitlementResponse> forRoverEntitlement(GetRoverEntitlementRequest request, RoverEntitlement.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRoverEntitlement(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRoverEntitlementRequest, GetRoverEntitlementResponse> forRoverEntitlement(GetRoverEntitlementRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RoverEntitlement.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRoverEntitlement(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRoverEntitlementRequest, GetRoverEntitlementResponse> forRoverEntitlement(BmcGenericWaiter waiter, GetRoverEntitlementRequest request, RoverEntitlement.LifecycleState ... targetStates) {
        final HashSet<RoverEntitlement.LifecycleState> targetStatesSet = new HashSet<RoverEntitlement.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetRoverEntitlementRequest, GetRoverEntitlementResponse>(){

            public GetRoverEntitlementResponse apply(GetRoverEntitlementRequest request) {
                return RoverEntitlementWaiters.this.client.getRoverEntitlement(request);
            }
        }, (Predicate)new Predicate<GetRoverEntitlementResponse>(){

            public boolean apply(GetRoverEntitlementResponse response) {
                return targetStatesSet.contains((Object)response.getRoverEntitlement().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)RoverEntitlement.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public RoverEntitlementWaiters(ExecutorService executorService, RoverEntitlement client) {
        this.executorService = executorService;
        this.client = client;
    }
}

