/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.RoverNode;
import com.oracle.bmc.rover.model.RoverNodeSummary;
import com.oracle.bmc.rover.requests.ListRoverNodesRequest;
import com.oracle.bmc.rover.responses.ListRoverNodesResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class RoverNodePaginators {
    private final RoverNode client;

    public Iterable<ListRoverNodesResponse> listRoverNodesResponseIterator(final ListRoverNodesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoverNodesRequest.Builder>(){

            public ListRoverNodesRequest.Builder get() {
                return ListRoverNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverNodesResponse, String>(){

            public String apply(ListRoverNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverNodesRequest.Builder>, ListRoverNodesRequest>(){

            public ListRoverNodesRequest apply(RequestBuilderAndToken<ListRoverNodesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoverNodesRequest, ListRoverNodesResponse>(){

            public ListRoverNodesResponse apply(ListRoverNodesRequest request) {
                return RoverNodePaginators.this.client.listRoverNodes(request);
            }
        });
    }

    public Iterable<RoverNodeSummary> listRoverNodesRecordIterator(final ListRoverNodesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoverNodesRequest.Builder>(){

            public ListRoverNodesRequest.Builder get() {
                return ListRoverNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverNodesResponse, String>(){

            public String apply(ListRoverNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverNodesRequest.Builder>, ListRoverNodesRequest>(){

            public ListRoverNodesRequest apply(RequestBuilderAndToken<ListRoverNodesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoverNodesRequest, ListRoverNodesResponse>(){

            public ListRoverNodesResponse apply(ListRoverNodesRequest request) {
                return RoverNodePaginators.this.client.listRoverNodes(request);
            }
        }, (Function)new Function<ListRoverNodesResponse, List<RoverNodeSummary>>(){

            public List<RoverNodeSummary> apply(ListRoverNodesResponse response) {
                return response.getRoverNodeCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public RoverNodePaginators(RoverNode client) {
        this.client = client;
    }
}

