/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.rover.model.RoverNodeGetRpt;
import com.oracle.bmc.rover.requests.GetRoverNodeGetRptRequest;
import com.oracle.bmc.rover.responses.GetRoverNodeGetRptResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRoverNodeGetRptConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRoverNodeGetRptConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRoverNodeGetRptRequest interceptRequest(GetRoverNodeGetRptRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRoverNodeGetRptRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getJwt(), (String)"jwt is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201210").path("roverNodes").path(HttpUtils.encodePathSegment((String)request.getRoverNodeId())).path("getRpt");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        ib.header("jwt", (Object)request.getJwt());
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetRoverNodeGetRptResponse> fromResponse() {
        Function<Response, GetRoverNodeGetRptResponse> transformer = new Function<Response, GetRoverNodeGetRptResponse>(){

            public GetRoverNodeGetRptResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.rover.responses.GetRoverNodeGetRptResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RoverNodeGetRpt.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRoverNodeGetRptResponse.Builder builder = GetRoverNodeGetRptResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.roverNodeGetRpt((RoverNodeGetRpt)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetRoverNodeGetRptResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

